/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query.spans;

import de.ids_mannheim.korap.query.SpanAttributeQuery;
import de.ids_mannheim.korap.query.SpanWithAttributeQuery;
import de.ids_mannheim.korap.query.spans.AttributeSpans;
import de.ids_mannheim.korap.query.spans.SimpleSpans;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.Bits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpansWithAttribute
extends SimpleSpans {
    private SimpleSpans referentSpans;
    private List<AttributeSpans> attributeList;
    private List<AttributeSpans> notAttributeList;
    protected Logger logger = LoggerFactory.getLogger(SpansWithAttribute.class);

    public SpansWithAttribute(SpanWithAttributeQuery spanWithAttributeQuery, SimpleSpans referentSpans, LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        super(spanWithAttributeQuery, context, acceptDocs, termContexts);
        this.referentSpans = referentSpans;
        this.hasMoreSpans = referentSpans.next();
        this.setAttributeList(spanWithAttributeQuery, context, acceptDocs, termContexts);
    }

    public SpansWithAttribute(SpanWithAttributeQuery spanWithAttributeQuery, LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        super(spanWithAttributeQuery, context, acceptDocs, termContexts);
        this.hasMoreSpans = true;
        this.setAttributeList(spanWithAttributeQuery, context, acceptDocs, termContexts);
        if (this.attributeList.size() == 0) {
            throw new IllegalArgumentException("No (positive) attribute is defined.");
        }
        if (this.attributeList.size() > 1) {
            this.referentSpans = this.attributeList.get(0);
            this.attributeList.remove(0);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAttributeList(SpanWithAttributeQuery swaq, LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        this.attributeList = new ArrayList<AttributeSpans>();
        this.notAttributeList = new ArrayList<AttributeSpans>();
        List<SpanQuery> attributeList = swaq.getClauseList();
        if (swaq.isMultipleAttributes) {
            if (attributeList == null) throw new NullPointerException("Attribute list is null.");
            for (SpanQuery sq : attributeList) {
                this.addAttributes((SpanAttributeQuery)sq, context, acceptDocs, termContexts);
            }
            return;
        } else if (swaq.getSecondClause() != null) {
            this.addAttributes((SpanAttributeQuery)swaq.getSecondClause(), context, acceptDocs, termContexts);
            return;
        } else {
            if (!swaq.getType().equals("spanWithAttribute") || swaq.getFirstClause() == null) throw new NullPointerException("No attribute is defined.");
            this.addAttributes((SpanAttributeQuery)swaq.getFirstClause(), context, acceptDocs, termContexts);
        }
    }

    private void addAttributes(SpanAttributeQuery sq, LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        AttributeSpans as = (AttributeSpans)sq.getSpans(context, acceptDocs, termContexts);
        if (sq.isNegation()) {
            this.notAttributeList.add(as);
            as.next();
        } else {
            this.attributeList.add(as);
            this.hasMoreSpans &= as.next();
        }
    }

    @Override
    public boolean next() throws IOException {
        this.isStartEnumeration = false;
        this.matchPayload.clear();
        if (this.referentSpans == null) {
            return this.advanceAttribute();
        }
        return this.advance();
    }

    private boolean advanceAttribute() throws IOException {
        while (this.hasMoreSpans) {
            SimpleSpans referentSpans = this.attributeList.get(0);
            this.advanceNotAttributes(referentSpans);
            if (!this.checkNotReferentId(referentSpans)) continue;
            this.matchDocNumber = referentSpans.doc();
            this.matchStartPosition = referentSpans.start();
            this.matchEndPosition = referentSpans.end();
            this.matchPayload = referentSpans.getPayload();
            this.spanId = referentSpans.getSpanId();
            if (this.spanId > 0) {
                this.hasSpanId = true;
            }
            this.hasMoreSpans = referentSpans.next();
            return true;
        }
        return false;
    }

    private boolean advance() throws IOException {
        while (this.hasMoreSpans && this.searchSpanPosition()) {
            if (!this.checkReferentId() || !this.checkNotReferentId(this.referentSpans)) continue;
            this.matchDocNumber = this.referentSpans.doc();
            this.matchStartPosition = this.referentSpans.start();
            this.matchEndPosition = this.referentSpans.end();
            this.matchPayload.addAll(this.referentSpans.getPayload());
            this.spanId = this.referentSpans.getSpanId();
            if (this.attributeList.size() > 0) {
                this.hasMoreSpans = this.attributeList.get(0).next();
            }
            this.hasMoreSpans &= this.referentSpans.next();
            return true;
        }
        return false;
    }

    private boolean searchSpanPosition() throws IOException {
        while (this.hasMoreSpans) {
            if (this.referentSpans.getSpanId() < 1) {
                if (this.attributeList.size() == 0 || this.notAttributeList.size() > 0) {
                    return true;
                }
                this.hasMoreSpans = this.referentSpans.next();
                continue;
            }
            if (!this.checkAttributeListPosition()) continue;
            this.advanceNotAttributes(this.referentSpans);
            return true;
        }
        return false;
    }

    private boolean checkAttributeListPosition() throws IOException {
        int currentPosition = this.referentSpans.start();
        boolean isSame = true;
        boolean isFirst = true;
        for (AttributeSpans a : this.attributeList) {
            if (!this.ensureSamePosition(this.referentSpans, a)) {
                return false;
            }
            if (isFirst) {
                isFirst = false;
                currentPosition = this.referentSpans.start();
                continue;
            }
            if (currentPosition == this.referentSpans.start()) continue;
            currentPosition = this.referentSpans.start();
            isSame = false;
        }
        return isSame;
    }

    private boolean ensureSamePosition(SimpleSpans spans, AttributeSpans attributes) throws IOException {
        while (this.hasMoreSpans && this.ensureSameDoc(spans, attributes)) {
            if (attributes.start() == spans.start() && attributes.end() == spans.end()) {
                return true;
            }
            if (attributes.start() >= spans.start()) {
                this.hasMoreSpans = spans.next();
                continue;
            }
            this.hasMoreSpans = attributes.next();
        }
        return false;
    }

    private void advanceNotAttributes(Spans referentSpans) throws IOException {
        for (AttributeSpans a : this.notAttributeList) {
            while (!(a.isFinish() || a.doc() > referentSpans.doc() || a.doc() == referentSpans.doc() && a.start() >= referentSpans.start())) {
                if (a.next()) continue;
                a.setFinish(true);
            }
        }
    }

    private boolean checkReferentId() throws IOException {
        for (AttributeSpans attribute : this.attributeList) {
            if (this.referentSpans.getSpanId() == attribute.getSpanId()) continue;
            this.hasMoreSpans = this.referentSpans.getSpanId() < attribute.getSpanId() ? attribute.next() : this.referentSpans.next();
            return false;
        }
        return true;
    }

    private boolean checkNotReferentId(SimpleSpans referentSpans) throws IOException {
        for (AttributeSpans notAttribute : this.notAttributeList) {
            if (notAttribute.isFinish() || referentSpans.start() != notAttribute.start() || referentSpans.getSpanId() != notAttribute.getSpanId()) continue;
            this.hasMoreSpans = referentSpans.next();
            return false;
        }
        return true;
    }

    @Override
    public boolean skipTo(int target) throws IOException {
        if (this.hasMoreSpans && this.referentSpans.doc() < target && !this.referentSpans.skipTo(target)) {
            return false;
        }
        this.isStartEnumeration = false;
        return this.advance();
    }

    @Override
    public long cost() {
        long cost = 0L;
        for (AttributeSpans as : this.attributeList) {
            cost += as.cost();
        }
        for (AttributeSpans as : this.notAttributeList) {
            cost += as.cost();
        }
        if (this.referentSpans != null) {
            return this.referentSpans.cost() + cost;
        }
        return cost;
    }
}

