/*
 * Decompiled with CFR 0.152.
 */
package lemming.test.lemma.toutanova;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import lemming.lemma.LemmaInstance;
import lemming.lemma.toutanova.FirstOrderDecoder;
import lemming.lemma.toutanova.Result;
import lemming.lemma.toutanova.ToutanovaInstance;
import lemming.lemma.toutanova.ToutanovaModel;
import lemming.lemma.toutanova.ToutanovaTrainer;
import org.junit.Assert;
import org.junit.Test;

public class DecoderTest {
    @Test
    public void test() {
        ToutanovaModel model = new ToutanovaModel();
        LinkedList<ToutanovaInstance> train_instances = new LinkedList<ToutanovaInstance>();
        train_instances.add(new ToutanovaInstance(new LemmaInstance("aaae", "aaa", null, null), Arrays.asList(1, 1, 1, 1, 2, 1)));
        train_instances.add(new ToutanovaInstance(new LemmaInstance("bbbe", "bbb", null, null), Arrays.asList(1, 1, 1, 1, 2, 1)));
        train_instances.add(new ToutanovaInstance(new LemmaInstance("ccce", "ccc", null, null), Arrays.asList(1, 1, 1, 1, 2, 1)));
        train_instances.add(new ToutanovaInstance(new LemmaInstance("aaaf", "aaa", null, null), Arrays.asList(1, 1, 1, 1, 2, 1)));
        train_instances.add(new ToutanovaInstance(new LemmaInstance("bbbf", "bbb", null, null), Arrays.asList(1, 1, 1, 1, 2, 1)));
        train_instances.add(new ToutanovaInstance(new LemmaInstance("cccf", "ccc", null, null), Arrays.asList(1, 1, 1, 1, 2, 1)));
        model.init(ToutanovaTrainer.ToutanovaOptions.newInstance(), train_instances, null);
        FirstOrderDecoder decoder = new FirstOrderDecoder();
        decoder.init(model);
        int a_index = model.getOutputTable().toIndex("a");
        int b_index = model.getOutputTable().toIndex("b");
        int c_index = model.getOutputTable().toIndex("c");
        this.assertResultEquals(Arrays.asList(a_index, a_index, a_index), Arrays.asList(1, 2, 4), decoder.decode((ToutanovaInstance)train_instances.get(0)));
        this.assertResultEquals(Arrays.asList(a_index, a_index, a_index), Arrays.asList(1, 2, 4), decoder.decode((ToutanovaInstance)train_instances.get(3)));
        this.assertResultEquals(Arrays.asList(b_index, b_index, b_index), Arrays.asList(1, 2, 4), decoder.decode((ToutanovaInstance)train_instances.get(1)));
        this.assertResultEquals(Arrays.asList(b_index, b_index, b_index), Arrays.asList(1, 2, 4), decoder.decode((ToutanovaInstance)train_instances.get(4)));
        this.assertResultEquals(Arrays.asList(c_index, c_index, c_index), Arrays.asList(1, 2, 4), decoder.decode((ToutanovaInstance)train_instances.get(2)));
        this.assertResultEquals(Arrays.asList(c_index, c_index, c_index), Arrays.asList(1, 2, 4), decoder.decode((ToutanovaInstance)train_instances.get(5)));
    }

    private void assertResultEquals(List<Integer> outputs, List<Integer> inputs, Result result) {
        Assert.assertEquals(outputs, result.getOutputs());
        Assert.assertEquals(inputs, result.getInputs());
    }
}

