/*
 * Decompiled with CFR 0.152.
 */
package marmot.morph.cmd;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import marmot.core.FeatureVector;
import marmot.core.Sequence;
import marmot.core.Token;
import marmot.morph.MorphModel;
import marmot.morph.MorphOptions;
import marmot.morph.MorphWeightVector;
import marmot.morph.Word;
import marmot.morph.io.SentenceReader;
import marmot.util.FileUtils;

public class FeaturePrinter {
    public static void main(String[] args2) {
        MorphOptions options = new MorphOptions();
        options.setPropertiesFromStrings(args2);
        options.setProperty("initial-vector-size", "1");
        MorphModel model = new MorphModel();
        LinkedList<Sequence> sentences = new LinkedList<Sequence>();
        for (Sequence sentence : new SentenceReader(options.getTrainFile())) {
            sentences.add(sentence);
        }
        model.init(options, sentences);
        sentences = null;
        MorphWeightVector weights = new MorphWeightVector(options);
        weights.init(model, sentences);
        try {
            weights.setExtendFeatureSet(true);
            FeaturePrinter.printFeatures(model, options, weights, options.getTrainFile(), "trn.txt.feat");
            weights.setExtendFeatureSet(false);
            FeaturePrinter.printFeatures(model, options, weights, options.getTestFile(), "tst.txt.feat");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void printFeatures(MorphModel model, MorphOptions options, MorphWeightVector weights, String filename, String out_filename) throws IOException {
        String separator = "\t";
        Writer writer = FileUtils.openFileWriter(out_filename);
        for (Sequence sentence : new SentenceReader(filename)) {
            Word word;
            int index = 0;
            for (Token token : sentence) {
                word = (Word)token;
                model.addIndexes(word, false);
            }
            for (Token token : sentence) {
                word = (Word)token;
                FeatureVector vector = weights.extractStateFeatures(sentence, index);
                writer.write("pos=");
                writer.write(word.getPosTag());
                if (options.getTagMorph()) {
                    writer.write("|");
                    writer.write(word.getMorphTag());
                }
                for (int findex = 0; findex < vector.size(); ++findex) {
                    int feature = vector.get(findex);
                    writer.write(separator);
                    writer.write(FeaturePrinter.toString(feature));
                }
                writer.write(10);
                ++index;
            }
            writer.write(10);
        }
        writer.close();
    }

    private static String toString(int feature) {
        return Integer.toString(feature, 36);
    }
}

