/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ForExpressionCompiler;
import com.saxonica.ee.bytecode.ToIteratorCompiler;
import com.saxonica.ee.bytecode.map.ForSequenceMappingAction;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ForExpression;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.OuterForExpression;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.LookaheadIteratorImpl;
import net.sf.saxon.value.EmptySequence;

public class OuterForExpressionCompiler
extends ToIteratorCompiler {
    @Override
    public void compileToPush(CompilerService compiler, Expression expression) throws CannotCompileException {
        Expression sequence = ((OuterForExpression)expression).getSequence();
        Expression action = ((OuterForExpression)expression).getAction();
        int slotNum = ((OuterForExpression)expression).getLocalSlotNumber();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        OuterForExpressionCompiler.visitAnnotation(compiler, "OuterForExpression-push");
        int positionVar = methodInfo.allocateLocal(Integer.TYPE);
        ga.push(1);
        ga.storeLocal(positionVar);
        LabelInfo noNextItem = methodInfo.newLabel("noNextItem");
        LabelInfo end = methodInfo.newLabel("end_OuterFor");
        LabelInfo itemNull = methodInfo.newLabel("itemNull_OuterFor");
        compiler.compileToIterator(sequence);
        ga.invokeStaticMethod(LookaheadIteratorImpl.class, "makeLookaheadIterator", SequenceIterator.class);
        int iterVar = methodInfo.allocateLocal(LookaheadIterator.class);
        ga.storeLocal(iterVar);
        ga.loadLocal(iterVar);
        ga.invokeInstanceMethod(LookaheadIterator.class, "hasNext", new Class[0]);
        ga.ifFalse(noNextItem);
        LabelInfo loop = methodInfo.placeNewLabel("loopFor");
        ga.loadLocal(iterVar);
        ga.invokeInstanceMethod(LookaheadIterator.class, "next", new Class[0]);
        ga.dup();
        ga.ifNull(itemNull.label());
        compiler.generateGetContext();
        ga.swap();
        ga.push(slotNum);
        ga.swap();
        ga.invokeInstanceMethod(XPathContext.class, "setLocalVariable", Integer.TYPE, Sequence.class);
        compiler.compileToPush(action);
        ga.goTo(loop);
        methodInfo.placeLabel(itemNull);
        ga.pop();
        ga.goTo(end);
        methodInfo.placeLabel(noNextItem);
        compiler.generateGetContext();
        ga.push(slotNum);
        ga.invokeStaticMethod(EmptySequence.class, "getInstance", new Class[0]);
        ga.invokeInstanceMethod(XPathContext.class, "setLocalVariable", Integer.TYPE, Sequence.class);
        compiler.compileToPush(action);
        methodInfo.placeLabel(end);
        methodInfo.releaseLocal(iterVar);
        methodInfo.releaseLocal(positionVar);
    }

    @Override
    public void compileToIterator(CompilerService compiler, Expression expression) throws CannotCompileException {
        Expression sequence = ((OuterForExpression)expression).getSequence();
        Expression action = ((OuterForExpression)expression).getAction();
        int slotNum = ((OuterForExpression)expression).getLocalSlotNumber();
        OuterForExpressionCompiler.visitAnnotation(compiler, "OuterForexpression-itr");
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        LabelInfo noNextItem = methodInfo.newLabel("noNextItem");
        LabelInfo end = methodInfo.newLabel("end_OuterFor");
        compiler.compileToIterator(sequence);
        ga.invokeStaticMethod(LookaheadIteratorImpl.class, "makeLookaheadIterator", SequenceIterator.class);
        int iterVar = methodInfo.allocateLocal(LookaheadIterator.class);
        ga.storeLocal(iterVar);
        ga.loadLocal(iterVar);
        ga.invokeInstanceMethod(LookaheadIterator.class, "hasNext", new Class[0]);
        ga.ifFalse(noNextItem);
        ga.newInstance(MappingIterator.class);
        ga.dup();
        ga.loadLocal(iterVar);
        Class mappingActionClass = compiler.getCompiledClass(expression);
        if (mappingActionClass == null) {
            mappingActionClass = ForExpressionCompiler.generateSequenceMappingAction(compiler, (ForExpression)expression, action, slotNum);
            compiler.setCompiledClass(expression, mappingActionClass);
        }
        OuterForExpressionCompiler.allocateStatic(compiler, mappingActionClass);
        ga.invokeInstanceMethod(Class.class, "newInstance", new Class[0]);
        ga.checkClass(ForSequenceMappingAction.class);
        ga.dup();
        compiler.generateGetContext();
        ga.invokeInstanceMethod(ForSequenceMappingAction.class, "setContext", XPathContext.class);
        ga.invokeConstructor(MappingIterator.class, SequenceIterator.class, MappingFunction.class);
        ga.goTo(end);
        methodInfo.placeLabel(noNextItem);
        compiler.generateGetContext();
        ga.push(slotNum);
        ga.invokeStaticMethod(EmptySequence.class, "getInstance", new Class[0]);
        ga.invokeInstanceMethod(XPathContext.class, "setLocalVariable", Integer.TYPE, Sequence.class);
        compiler.compileToIterator(action);
        ga.checkClass(SequenceIterator.class);
        methodInfo.placeLabel(end);
    }
}

