/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ExpressionCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.NumericType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public abstract class ToIteratorCompiler
extends ExpressionCompiler {
    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        compiler.compileToIterator(expression);
        ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
    }

    @Override
    public void compileToPush(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        ToIteratorCompiler.visitAnnotation(compiler, "ToIteratorCompilerPush");
        this.compileToIterator(compiler, expression);
        int iterVar = methodInfo.allocateLocal(SequenceIterator.class);
        ga.storeLocal(iterVar);
        LabelInfo done = methodInfo.newLabel("doneToItr");
        LabelInfo loop = methodInfo.placeNewLabel("loop");
        ga.loadLocal(iterVar);
        ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
        ga.dup();
        ga.ifNull(done.label());
        compiler.generateGetReceiver();
        ga.swap();
        ToIteratorCompiler.allocateStatic(compiler, expression.getLocation());
        ga.push(524288);
        ga.invokeInstanceMethod(Receiver.class, "append", Item.class, Location.class, Integer.TYPE);
        ga.goTo(loop);
        methodInfo.placeLabel(done);
        ga.pop();
        methodInfo.releaseLocal(iterVar);
    }

    @Override
    public void compileToBoolean(CompilerService compiler, Expression expression) throws CannotCompileException {
        int relToNode;
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        TypeHierarchy th = compiler.getConfiguration().getTypeHierarchy();
        LabelInfo end = methodInfo.newLabel("endToIterB");
        LabelInfo checkNoMoreItems = methodInfo.newLabel("checkNoMoreItems");
        LabelInfo error = methodInfo.newLabel("error");
        LabelInfo returnFalse = methodInfo.newLabel("false");
        boolean needToCheckForMore = false;
        ToIteratorCompiler.visitAnnotation(compiler, "ToIteratorCompiler.compileToBoolean(" + expression + ")");
        this.compileToIterator(compiler, expression);
        int iterVar = methodInfo.allocateLocal(SequenceIterator.class);
        ga.dup();
        ga.storeLocal(iterVar);
        ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
        int itemVar = methodInfo.allocateLocal(SequenceIterator.class);
        ga.storeLocal(itemVar);
        if (Cardinality.allowsZero(expression.getCardinality())) {
            ToIteratorCompiler.visitAnnotation(compiler, "ToIteratorCompiler.compileToBoolean(): test if empty");
            LabelInfo notEmptySequence = methodInfo.newLabel("notEmptySequence");
            ga.loadLocal(itemVar);
            ga.ifNonNull(notEmptySequence.label());
            ga.push(false);
            ga.goTo(end);
            methodInfo.placeLabel(notEmptySequence);
        }
        if (th.relationship(expression.getItemType(), BuiltInAtomicType.BOOLEAN) != 4) {
            ToIteratorCompiler.visitAnnotation(compiler, "ToIteratorCompiler.compileToBoolean(): test boolean value");
            ga.loadLocal(itemVar);
            LabelInfo notBoolean = methodInfo.newLabel("notBoolean");
            ga.ifNotInstance(BooleanValue.class, notBoolean);
            ga.loadLocal(itemVar);
            ga.checkClass(BooleanValue.class);
            ga.invokeInstanceMethod(BooleanValue.class, "getBooleanValue", new Class[0]);
            if (Cardinality.allowsMany(expression.getCardinality())) {
                needToCheckForMore = true;
                ga.goTo(checkNoMoreItems);
            } else {
                ga.goTo(end);
            }
            methodInfo.placeLabel(notBoolean);
        }
        if (th.relationship(expression.getItemType(), NumericType.getInstance()) != 4) {
            ToIteratorCompiler.visitAnnotation(compiler, "ToIteratorCompiler.compileToBoolean(): test numeric value");
            ga.loadLocal(itemVar);
            LabelInfo notNumeric = methodInfo.newLabel("notNumeric");
            ga.ifNotInstance(NumericValue.class, notNumeric);
            if (th.relationship(expression.getItemType(), BuiltInAtomicType.DOUBLE) != 4 || th.relationship(expression.getItemType(), BuiltInAtomicType.FLOAT) != 4) {
                ToIteratorCompiler.visitAnnotation(compiler, "ToIteratorCompiler.compileToBoolean(): test for NaN");
                ga.loadLocal(itemVar);
                ga.checkClass(AtomicValue.class);
                ga.invokeInstanceMethod(AtomicValue.class, "isNaN", new Class[0]);
                LabelInfo notNaN = methodInfo.newLabel("notNaN");
                ga.ifFalse(notNaN);
                ga.push(false);
                if (Cardinality.allowsMany(expression.getCardinality())) {
                    needToCheckForMore = true;
                    ga.goTo(checkNoMoreItems);
                } else {
                    ga.goTo(end);
                }
                methodInfo.placeLabel(notNaN);
            }
            ga.loadLocal(itemVar);
            ga.checkClass(NumericValue.class);
            ga.push(0L);
            ga.invokeInstanceMethod(NumericValue.class, "compareTo", Long.TYPE);
            LabelInfo numericZero = methodInfo.newLabel("numericZero");
            ga.ifZCmp(153, numericZero.label());
            ga.push(true);
            if (Cardinality.allowsMany(expression.getCardinality())) {
                needToCheckForMore = true;
                ga.goTo(checkNoMoreItems);
            } else {
                ga.goTo(end);
            }
            methodInfo.placeLabel(numericZero);
            ga.push(false);
            if (Cardinality.allowsMany(expression.getCardinality())) {
                needToCheckForMore = true;
                ga.goTo(checkNoMoreItems);
            } else {
                ga.goTo(end);
            }
            methodInfo.placeLabel(notNumeric);
        }
        if (th.relationship(expression.getItemType(), BuiltInAtomicType.STRING) != 4 || th.relationship(expression.getItemType(), BuiltInAtomicType.ANY_URI) != 4 || th.relationship(expression.getItemType(), BuiltInAtomicType.UNTYPED_ATOMIC) != 4) {
            ToIteratorCompiler.visitAnnotation(compiler, "ToIteratorCompiler.compileToBoolean(): test string value");
            ga.loadLocal(itemVar);
            LabelInfo notString = methodInfo.newLabel("notString");
            ga.ifNotInstance(StringValue.class, notString);
            ga.loadLocal(itemVar);
            ga.checkClass(StringValue.class);
            ga.invokeInstanceMethod(StringValue.class, "isZeroLength", new Class[0]);
            ga.not();
            if (Cardinality.allowsMany(expression.getCardinality())) {
                needToCheckForMore = true;
                ga.goTo(checkNoMoreItems);
            } else {
                ga.goTo(end);
            }
            methodInfo.placeLabel(notString);
        }
        if ((relToNode = th.relationship(expression.getItemType(), AnyNodeTest.getInstance())) == 0 || relToNode == 2) {
            ToIteratorCompiler.visitAnnotation(compiler, "ToIteratorCompiler.compileToBoolean(): node exists");
            ga.push(true);
            ga.goTo(end);
        } else if (relToNode != 4) {
            ToIteratorCompiler.visitAnnotation(compiler, "ToIteratorCompiler.compileToBoolean(): test node existence");
            ga.loadLocal(itemVar);
            ga.ifNotInstance(NodeInfo.class, error);
            ga.push(true);
            ga.goTo(end);
        } else {
            ga.goTo(error);
        }
        if (needToCheckForMore) {
            ToIteratorCompiler.visitAnnotation(compiler, "ToIteratorCompiler.compileToBoolean(): check no more items");
            methodInfo.placeLabel(checkNoMoreItems);
            ga.loadLocal(iterVar);
            ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
            ga.ifNull(end.label());
            ga.pop();
        }
        methodInfo.placeLabel(error);
        compiler.generateDynamicError("Effective boolean value is not defined", "FORG0006", expression.getLocation(), false);
        methodInfo.placeLabel(returnFalse);
        ga.push(false);
        ToIteratorCompiler.visitAnnotation(compiler, "ToIteratorCompiler.compileToBoolean(): return");
        methodInfo.placeLabel(end);
        methodInfo.releaseLocal(iterVar);
        methodInfo.releaseLocal(itemVar);
    }
}

