/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.om;

import com.saxonica.ee.stream.om.AttributeIterator;
import com.saxonica.ee.stream.om.FleetingParentNode;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.NamespaceNode;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.type.SchemaType;

public class FleetingElementNode
extends FleetingParentNode {
    private NamespaceBinding[] localNamespaces;
    private AttributeCollection attributes;

    public FleetingElementNode(NodeName name, SchemaType type) {
        this.setNodeKind(1);
        this.setNodeName(name);
        this.setTypeAnnotation(type);
    }

    public void setLocalNamespaces(NamespaceBinding[] namespaces) {
        this.localNamespaces = namespaces;
    }

    public void setAttributes(AttributeCollection attributes) {
        this.attributes = attributes;
    }

    @Override
    public void copy(Receiver out, int copyOptions, Location locationId) throws XPathException {
        throw new UnsupportedOperationException("copy() is not supported for streamed " + Err.wrap(this.getDisplayName(), 1) + " element node");
    }

    @Override
    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        switch (axisNumber) {
            case 2: {
                if (this.attributes.getLength() == 0) {
                    return EmptyIterator.OfNodes.THE_INSTANCE;
                }
                return new AttributeIterator(this, this.attributes, nodeTest);
            }
            case 8: {
                return NamespaceNode.makeIterator(this, nodeTest);
            }
        }
        return super.iterateAxis(axisNumber, nodeTest);
    }

    public AttributeCollection getAttributes() {
        return this.attributes;
    }

    @Override
    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] buffer) {
        return this.localNamespaces;
    }

    @Override
    public String getAttributeValue(String uri, String local) {
        return this.attributes.getValue(uri, local);
    }

    public int getAttributeIndex(String uri, String local) {
        return this.attributes.getIndex(uri, local);
    }

    public int getNamespaceNodeIndex(String prefix) {
        NodeInfo node;
        int index = 0;
        AxisIterator iter = this.iterateAxis((byte)8);
        while ((node = iter.next()) != null) {
            ++index;
            if (!node.getLocalPart().equals(prefix)) continue;
            return index;
        }
        return -1;
    }
}

