/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode.util;

import com.saxonica.ee.bytecode.AccessorFnCompiler;
import com.saxonica.ee.bytecode.BaseURICompiler;
import com.saxonica.ee.bytecode.BooleanFnCompiler;
import com.saxonica.ee.bytecode.ByteCodeCandidate;
import com.saxonica.ee.bytecode.CompiledExpression;
import com.saxonica.ee.bytecode.ConcatCompiler;
import com.saxonica.ee.bytecode.ContainsCompiler;
import com.saxonica.ee.bytecode.CountCompiler;
import com.saxonica.ee.bytecode.DateTimeConstructorCompiler;
import com.saxonica.ee.bytecode.EmptyCompiler;
import com.saxonica.ee.bytecode.ExistsCompiler;
import com.saxonica.ee.bytecode.ExpressionCompiler;
import com.saxonica.ee.bytecode.ForceCaseCompiler;
import com.saxonica.ee.bytecode.GenerateIdCompiler;
import com.saxonica.ee.bytecode.GeneratedCode;
import com.saxonica.ee.bytecode.LastCompiler;
import com.saxonica.ee.bytecode.LocalNameCompiler;
import com.saxonica.ee.bytecode.MatchesCompiler;
import com.saxonica.ee.bytecode.NameCompiler;
import com.saxonica.ee.bytecode.NamespaceUriFnCompiler;
import com.saxonica.ee.bytecode.NodeNameFnCompiler;
import com.saxonica.ee.bytecode.NormalizeSpaceCompiler;
import com.saxonica.ee.bytecode.NotFnCompiler;
import com.saxonica.ee.bytecode.NumberFnCompiler;
import com.saxonica.ee.bytecode.PositionCompiler;
import com.saxonica.ee.bytecode.QNameFnCompiler;
import com.saxonica.ee.bytecode.RootFunctionCompiler;
import com.saxonica.ee.bytecode.RoundingCompiler;
import com.saxonica.ee.bytecode.StartsWithCompiler;
import com.saxonica.ee.bytecode.StringFnCompiler;
import com.saxonica.ee.bytecode.StringJoinCompiler;
import com.saxonica.ee.bytecode.StringLengthCompiler;
import com.saxonica.ee.bytecode.SubstringAfterCompiler;
import com.saxonica.ee.bytecode.SubstringBeforeCompiler;
import com.saxonica.ee.bytecode.SubstringCompiler;
import com.saxonica.ee.bytecode.SumCompiler;
import com.saxonica.ee.bytecode.TranslateCompiler;
import com.saxonica.ee.bytecode.VariableReferenceCompiler;
import com.saxonica.ee.bytecode.simtype.AtomicTypeValidator;
import com.saxonica.ee.bytecode.simtype.AtomicTypeValidatorCompiler;
import com.saxonica.ee.bytecode.util.Callback;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.ExpressionCompilerMap;
import com.saxonica.ee.bytecode.util.GeneratedClassLoader;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.MessageBuilder;
import com.saxonica.ee.bytecode.util.OnEmpty;
import com.saxonica.ee.schema.UserAtomicType;
import com.saxonica.objectweb.asm.ClassVisitor;
import com.saxonica.objectweb.asm.ClassWriter;
import com.saxonica.objectweb.asm.Type;
import com.saxonica.objectweb.asm.commons.Method;
import com.saxonica.objectweb.asm.util.TraceClassVisitor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Stack;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ICompilerService;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.om.IdentityComparable;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.IntegerValue;

public class CompilerService
implements ICompilerService {
    private Configuration config;
    private int flags = 3;
    private Stack<GeneratedMethodInfo> currentMethods = new Stack();
    private Stack<GeneratedClassInfo> currentClasses = new Stack();
    private ClassLoader myClassLoader = null;
    private int maxClasses = 10000;
    private static int classCounter = 0;
    private int hostLanguage;
    private HashMap<ExpressionCompiler, GeneratedExpression> addMethods = new HashMap();
    public static int tracePoint = 0;
    private static int sequenceNumber = 0;
    private boolean displayByteCode;
    private boolean debugByteCode;
    private String debugByteCodeDirectory;
    public int mostRecentLineNumber = -1;
    private static HashMap<String, ExpressionCompiler> expressionCompilers = new HashMap();
    public HashMap<ObjectIdentityWrapper, StaticSubClasses> cClassMap = new HashMap();
    private static int verifyErrors;

    public CompilerService(Configuration config, int hostLanguage) {
        this.config = config;
        this.hostLanguage = hostLanguage;
        if (config.getBooleanProperty(Feature.DEBUG_BYTE_CODE)) {
            this.flags = 1;
            this.displayByteCode = true;
            this.debugByteCode = true;
            this.debugByteCodeDirectory = config.getConfigurationProperty(Feature.DEBUG_BYTE_CODE_DIR);
            if (this.debugByteCodeDirectory == null) {
                this.debugByteCodeDirectory = "saxonByteCode";
            }
        }
        if (config.getBooleanProperty(Feature.DISPLAY_BYTE_CODE)) {
            this.displayByteCode = true;
        }
        this.maxClasses = config.getConfigurationProperty(Feature.MAX_COMPILED_CLASSES);
    }

    public static boolean isLanguagePrimitiveType(AtomicType targetType) {
        int prim = targetType.getFingerprint();
        return prim == 513 || prim == 514 || prim == 517 || prim == 516 || prim == 631 || prim == 533;
    }

    public boolean isDisplayByteCode() {
        return this.displayByteCode;
    }

    public boolean isDebugByteCode() {
        return this.debugByteCode;
    }

    public int getHostLanguage() {
        return this.hostLanguage;
    }

    public PrintWriter createPrintWriter(String filename) {
        if (this.debugByteCodeDirectory != null) {
            File dir = new File(this.debugByteCodeDirectory);
            dir.mkdirs();
            File file = new File(dir, filename);
            try {
                return new PrintWriter(new FileWriter(file, true));
            }
            catch (IOException e) {
                return new PrintWriter(System.out);
            }
        }
        return new PrintWriter(System.out);
    }

    public ExpressionCompiler getNamedExpressionCompiler(String name) {
        ExpressionCompiler ec = expressionCompilers.get(name);
        if (ec == null) {
            try {
                ec = (ExpressionCompiler)this.config.getInstance("com.saxonica.ee.bytecode." + name, null);
                expressionCompilers.put(name, ec);
            }
            catch (XPathException e) {
                throw new AssertionError((Object)e);
            }
        }
        return ec;
    }

    public void addNewMethod(ExpressionCompiler ec, Expression e) {
        this.addMethods.put(ec, new GeneratedExpression(ec, e));
    }

    public void compileToSequence(Expression expression) throws CannotCompileException {
        Generator ga = this.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = this.getCurrentMethod();
        if (expression instanceof VariableReference) {
            VariableReferenceCompiler.compileToSequence(this, (VariableReference)expression);
        } else if (expression instanceof Literal) {
            if (Literal.isEmptySequence(expression)) {
                ga.invokeStaticMethod(EmptySequence.class, "getInstance", new Class[0]);
            } else {
                ExpressionCompiler.allocateStatic(this, ((Literal)expression).getValue());
            }
        } else if (Cardinality.allowsMany(expression.getCardinality())) {
            this.compileToIterator(expression);
            ga.invokeInstanceMethod(SequenceIterator.class, "materialize", new Class[0]);
        } else {
            this.compileToItem(expression);
            if (Cardinality.allowsZero(expression.getCardinality())) {
                LabelInfo nonNull = methodInfo.newLabel("nonNull");
                ga.dup();
                ga.ifNonNull(nonNull.label());
                ga.pop();
                ga.invokeStaticMethod(EmptySequence.class, "getInstance", new Class[0]);
                methodInfo.placeLabel(nonNull);
            }
        }
    }

    public Class getCompiledClass(Expression expr) {
        ObjectIdentityWrapper oiw = new ObjectIdentityWrapper(expr);
        if (this.cClassMap.get(oiw) != null) {
            return (Class)this.cClassMap.get((Object)oiw).object;
        }
        return null;
    }

    public void setCompiledClass(Expression expr, Class clss) {
        StaticSubClasses staticSubClass = new StaticSubClasses();
        staticSubClass.name = expr.getExpressionName();
        staticSubClass.object = clss;
        ObjectIdentityWrapper oiw = new ObjectIdentityWrapper(expr);
        this.cClassMap.put(oiw, staticSubClass);
    }

    public static int getUniqueNumber() {
        return sequenceNumber++;
    }

    public void pushNewReceiverInfo(Generator ga) {
        GeneratedMethodInfo methodInfo = this.getCurrentMethod();
        int newReceiverPosition = methodInfo.allocateLocal(SequenceReceiver.class);
        if (!methodInfo.isSequenceReceiverInitialized()) {
            int oldReceiverPosition = methodInfo.allocateLocal(SequenceReceiver.class);
            this.generateGetContext();
            ga.invokeInstanceMethod(XPathContext.class, "getReceiver", new Class[0]);
            ga.storeLocal(oldReceiverPosition);
            methodInfo.pushSequenceReceiverInfo(oldReceiverPosition);
        }
        ga.storeLocal(newReceiverPosition);
        this.generateGetContext();
        ga.loadLocal(newReceiverPosition);
        ga.invokeInstanceMethod(XPathContext.class, "setReceiver", Receiver.class);
        methodInfo.pushSequenceReceiverInfo(newReceiverPosition);
    }

    public void popReceiverInfo() {
        GeneratedMethodInfo methodInfo = this.getCurrentMethod();
        methodInfo.popSequenceReceiverInfo();
        this.generateGetContext();
        Generator ga = methodInfo.currentGenerator;
        ga.loadLocal(methodInfo.getSequenceReceiverPosition());
        ga.invokeInstanceMethod(XPathContext.class, "setReceiver", Receiver.class);
        if (!methodInfo.isSequenceReceiverInitialized()) {
            methodInfo.popSequenceReceiverInfo();
        }
    }

    public void pushNewMethodInfo(Generator ga, boolean contextIsArgument, int contextVariablePosition) {
        this.mostRecentLineNumber = -1;
        GeneratedMethodInfo methodInfo = new GeneratedMethodInfo();
        methodInfo.currentGenerator = ga;
        methodInfo.debug = this.isDebugByteCode();
        methodInfo.pushContextVariableInfo(contextVariablePosition, contextIsArgument);
        this.currentMethods.push(methodInfo);
        if (contextIsArgument) {
            ga.loadArg(contextVariablePosition);
            ga.invokeInstanceMethod(XPathContext.class, "getReceiver", new Class[0]);
            int receiverPosition = methodInfo.allocateLocal(SequenceReceiver.class);
            ga.storeLocal(receiverPosition);
            this.currentMethods.peek().pushSequenceReceiverInfo(receiverPosition);
        }
    }

    public void initNewMethod(Generator ga, boolean holdReceiverAsLocal) {
        GeneratedMethodInfo info = this.currentMethods.peek();
        if (holdReceiverAsLocal) {
            ga.dup();
            ga.storeLocal(info.getContextVariablePosition());
            ga.invokeInstanceMethod(XPathContext.class, "getReceiver", new Class[0]);
            int receiverPosition = ga.newLocal(SequenceReceiver.class);
            ga.storeLocal(receiverPosition);
            info.pushSequenceReceiverInfo(receiverPosition);
        } else {
            ga.storeLocal(info.getContextVariablePosition());
            info.pushSequenceReceiverInfo(-1);
        }
    }

    public void pushNewClassInfo(String className, Class superclass, ClassWriter cw) {
        GeneratedClassInfo generatedClassInfo = new GeneratedClassInfo();
        generatedClassInfo.setClassWriter(cw);
        generatedClassInfo.setSuperClass(superclass);
        generatedClassInfo.setClassName(className);
        this.currentClasses.push(generatedClassInfo);
    }

    public Stack<GeneratedMethodInfo> getCurrentMethods() {
        return this.currentMethods;
    }

    public GeneratedMethodInfo getCurrentMethod() {
        if (this.currentMethods.isEmpty()) {
            return null;
        }
        GeneratedMethodInfo m = this.currentMethods.peek();
        if (m.getCurrentGenerator() != this.getCurrentGenerator()) {
            throw new AssertionError((Object)"Generator mismatch");
        }
        return m;
    }

    public GeneratedClassInfo getCurrentClass() {
        return this.currentClasses.peek();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public int getFlags() {
        return this.flags;
    }

    public CompiledExpression compileToByteCode(Expression expr, String objectName, int evaluationModes) throws CannotCompileException {
        try {
            GeneratedCode gc;
            this.checkMaxClassesLimit();
            ClassWriter cw = new ClassWriter(this.flags);
            ClassVisitor cv = cw;
            String className = "EE_" + this.makeValidJavaName(objectName) + "_" + CompilerService.getUniqueNumber() + (expr.hashCode() & Integer.MAX_VALUE);
            cv = this.makeAnnotatedTraceClassVisitor(cv, className);
            cw.visitSource(expr.getLocation().getSystemId(), null);
            cv.visit(49, 1, className, null, "com/saxonica/ee/bytecode/GeneratedCode", new String[0]);
            this.pushNewClassInfo(className, GeneratedCode.class, cw);
            Method m = Method.getMethod("void <init> ()");
            Generator ga = new Generator(1, m, false, cv);
            ExpressionCompiler.visitLineNumber(this, ga, expr);
            ga.loadThis();
            ga.invokeConstructor(Type.getType(GeneratedCode.class), m);
            ga.returnValue();
            ga.endMethod();
            if ((evaluationModes & 2) != 0) {
                m = Method.getMethod("net.sf.saxon.om.SequenceIterator iterate(net.sf.saxon.expr.XPathContext)");
                ga = new Generator(1, m, true, cv);
                this.pushNewMethodInfo(ga, true, 0);
                try {
                    this.compileToIterator(expr);
                }
                catch (CannotCompileException e) {
                    this.handleCodeGeneratorException(objectName, e);
                    return null;
                }
                ga.returnValue();
                try {
                    ga.endMethod();
                }
                catch (Exception e) {
                    this.handleCodeGeneratorException(objectName, e);
                    return null;
                }
                this.popCurrentMethodInfo();
            }
            if ((evaluationModes & 1) != 0) {
                m = Method.getMethod("net.sf.saxon.om.Item evaluateItem(net.sf.saxon.expr.XPathContext)");
                ga = new Generator(1, m, true, cv);
                this.pushNewMethodInfo(ga, true, 0);
                try {
                    this.compileToItem(expr);
                }
                catch (CannotCompileException e) {
                    this.handleCodeGeneratorException(objectName, e);
                    return null;
                }
                ga.returnValue();
                try {
                    ga.endMethod();
                }
                catch (Exception e) {
                    this.handleCodeGeneratorException(objectName, e);
                    return null;
                }
                this.popCurrentMethodInfo();
                if ((evaluationModes & 2) == 0) {
                    m = Method.getMethod("net.sf.saxon.om.SequenceIterator iterate(net.sf.saxon.expr.XPathContext)");
                    ga = new Generator(1, m, true, cv);
                    this.pushNewMethodInfo(ga, true, 0);
                    ga.loadThis();
                    ga.loadArg(0);
                    ga.invokeInstanceMethod(GeneratedCode.class, "evaluateItem", XPathContext.class);
                    ga.invokeStaticMethod(SingletonIterator.class, "makeIterator", Item.class);
                    ga.returnValue();
                    try {
                        ga.endMethod();
                    }
                    catch (Exception e) {
                        this.handleCodeGeneratorException(objectName, e);
                        return null;
                    }
                    this.popCurrentMethodInfo();
                }
            }
            if (evaluationModes == 32) {
                m = Method.getMethod("boolean effectiveBooleanValue(net.sf.saxon.expr.XPathContext)");
                ga = new Generator(1, m, true, cv);
                this.pushNewMethodInfo(ga, true, 0);
                try {
                    this.compileToBoolean(expr);
                }
                catch (CannotCompileException e) {
                    this.handleCodeGeneratorException(objectName, e);
                    return null;
                }
                ga.returnValue();
                try {
                    ga.endMethod();
                }
                catch (Exception e) {
                    this.handleCodeGeneratorException(objectName, e);
                    return null;
                }
                this.popCurrentMethodInfo();
                m = Method.getMethod("net.sf.saxon.om.Item evaluateItem(net.sf.saxon.expr.XPathContext)");
                ga = new Generator(1, m, true, cv);
                this.pushNewMethodInfo(ga, true, 0);
                ga.loadThis();
                ga.loadArg(0);
                ga.invokeInstanceMethod(GeneratedCode.class, "effectiveBooleanValue", XPathContext.class);
                ga.invokeStaticMethod(BooleanValue.class, "get", Boolean.TYPE);
                ga.returnValue();
                try {
                    ga.endMethod();
                }
                catch (Exception e) {
                    this.handleCodeGeneratorException(objectName, e);
                    return null;
                }
                this.popCurrentMethodInfo();
                m = Method.getMethod("net.sf.saxon.om.SequenceIterator iterate(net.sf.saxon.expr.XPathContext)");
                ga = new Generator(1, m, true, cv);
                this.pushNewMethodInfo(ga, true, 0);
                ga.loadThis();
                ga.loadArg(0);
                ga.invokeInstanceMethod(GeneratedCode.class, "evaluateItem", XPathContext.class);
                ga.invokeStaticMethod(SingletonIterator.class, "makeIterator", Item.class);
                ga.returnValue();
                try {
                    ga.endMethod();
                }
                catch (Exception e) {
                    this.handleCodeGeneratorException(objectName, e);
                    return null;
                }
                this.popCurrentMethodInfo();
            }
            if ((evaluationModes & 4) != 0) {
                m = Method.getMethod("void process(net.sf.saxon.expr.XPathContext)");
                ga = new Generator(1, m, true, cv);
                this.pushNewMethodInfo(ga, true, 0);
                ExpressionCompiler.visitLineNumber(this, ga, expr);
                try {
                    this.compileToPush(expr);
                }
                catch (CannotCompileException e) {
                    this.handleCodeGeneratorException(objectName, e);
                    return null;
                }
                ga.returnValue();
                ga.endMethod();
                this.popCurrentMethodInfo();
            }
            for (GeneratedExpression ge : this.addMethods.values()) {
                ge.getExpressionCompiler().generateMethod(this, ge.getExpression(), cv);
            }
            cv.visitEnd();
            String message = objectName + " at line " + expr.getLocation().getLineNumber() + " in " + expr.getLocation().getSystemId();
            try {
                ExpressionCompiler.verify(cw, message, this.isDebugByteCode());
            }
            catch (IllegalStateException e) {
                for (Operand o : expr.operands()) {
                    Expression child = o.getChildExpression();
                    System.err.println("Trying to compile " + child.toString());
                    CompiledExpression compiledExpression = this.compileToByteCode(child, child.toString(), evaluationModes);
                }
            }
            Class generated = this.makeClass(cw, className);
            try {
                gc = (GeneratedCode)generated.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
                return null;
            }
            gc.setConfiguration(this.config);
            CompiledExpression compiledExpression = new CompiledExpression(expr, gc);
            compiledExpression.setClassName(className);
            return compiledExpression;
        }
        catch (ClassFormatError | VerifyError e) {
            this.handleCodeGeneratorException(objectName, e);
            this.currentClasses.pop();
            return null;
        }
        catch (RuntimeException e) {
            this.handleCodeGeneratorException(objectName, e);
            this.currentClasses.pop();
            return null;
        }
    }

    private void handleCodeGeneratorException(String objectName, Throwable e) {
        Expression exp;
        String message = e.getMessage();
        if (e instanceof CannotCompileException && (exp = ((CannotCompileException)e).getExpression()) != null) {
            Location loc = exp.getLocation();
            message = message + " at " + loc.getLineNumber() + " of " + loc.getSystemId();
        }
        if (!(e instanceof CannotCompileException) || !((CannotCompileException)e).isRecoverable()) {
            if (Configuration.isAssertionsEnabled() || this.isDebugByteCode()) {
                System.err.println("Cannot compile " + objectName + ": " + message);
                e.printStackTrace(System.err);
                throw new AssertionError((Object)e);
            }
            if (this.config.isTiming()) {
                this.config.getLogger().warning("Cannot compile " + objectName + "(" + message + ") - using interpreter");
            }
        }
    }

    public void compileToIterator(Expression expr) throws CannotCompileException {
        ExpressionCompiler comp = this.getExpressionCompiler(expr);
        if (expr instanceof ByteCodeCandidate) {
            expr = ((ByteCodeCandidate)expr).getBaseExpression();
        }
        comp.compileToIterator(this, expr);
    }

    public void compileToPush(Expression expr) throws CannotCompileException {
        ExpressionCompiler comp = this.getExpressionCompiler(expr);
        if (expr instanceof ByteCodeCandidate) {
            expr = ((ByteCodeCandidate)expr).getBaseExpression();
        }
        comp.compileToPush(this, expr);
    }

    public void compileToItem(Expression expr) throws CannotCompileException {
        ExpressionCompiler comp = this.getExpressionCompiler(expr);
        if (expr instanceof ByteCodeCandidate) {
            expr = ((ByteCodeCandidate)expr).getBaseExpression();
        }
        comp.compileToItem(this, expr);
    }

    public void compileToBoolean(Expression expr) throws CannotCompileException {
        ExpressionCompiler comp = this.getExpressionCompiler(expr);
        if (expr instanceof ByteCodeCandidate) {
            expr = ((ByteCodeCandidate)expr).getBaseExpression();
        }
        comp.compileToBoolean(this, expr);
    }

    public void compileToPrimitive(Expression expr, Class c) throws CannotCompileException {
        ExpressionCompiler comp = this.getExpressionCompiler(expr);
        if (expr instanceof ByteCodeCandidate) {
            expr = ((ByteCodeCandidate)expr).getBaseExpression();
        }
        comp.compileToPrimitive(this, expr, c, null);
    }

    private ExpressionCompiler getExpressionCompiler(Expression expr) throws CannotCompileException {
        return ExpressionCompilerMap.getExpressionCompiler(expr, this);
    }

    public boolean isInRangeForInt(Expression exp) {
        IntegerValue[] bounds = exp.getIntegerBounds();
        return bounds != null && bounds[0].compareTo(Integer.MIN_VALUE) >= 0 && bounds[1].compareTo(Integer.MAX_VALUE) <= 0;
    }

    public boolean isInRangeForLong(Expression exp) {
        IntegerValue[] bounds = exp.getIntegerBounds();
        return bounds != null && bounds[0].compareTo(Long.MIN_VALUE) >= 0 && bounds[1].compareTo(Long.MAX_VALUE) <= 0;
    }

    public void compileToPrimitive(Expression expr, Class requiredClass, OnEmpty onEmpty) throws CannotCompileException {
        ExpressionCompiler comp = this.getExpressionCompiler(expr);
        if (expr instanceof ByteCodeCandidate) {
            expr = ((ByteCodeCandidate)expr).getBaseExpression();
        }
        comp.compileToPrimitive(this, expr, requiredClass, onEmpty);
    }

    public Generator getCurrentGenerator() {
        return this.currentMethods.peek().currentGenerator;
    }

    public void popCurrentMethodInfo() {
        this.currentMethods.peek().checkLabels();
        this.currentMethods.pop();
    }

    public void generateGetContext() {
        GeneratedMethodInfo gci = this.currentMethods.peek();
        if (gci.isContextVariableAnArgument()) {
            this.getCurrentGenerator().loadArg(gci.getContextVariablePosition());
        } else {
            this.getCurrentGenerator().loadLocal(gci.getContextVariablePosition());
        }
    }

    public void generateGetReceiver() {
        GeneratedMethodInfo gci = this.currentMethods.peek();
        if (gci.getSequenceReceiverPosition() == -1) {
            this.generateGetContext();
            Generator ga = this.getCurrentGenerator();
            ga.invokeInstanceMethod(XPathContext.class, "getReceiver", new Class[0]);
        } else {
            this.getCurrentGenerator().loadLocal(gci.getSequenceReceiverPosition());
        }
    }

    public void generateDynamicError(String message, String errorCode, SourceLocator locator, boolean isTypeError) {
        Generator ga = this.getCurrentGenerator();
        ga.push(message);
        ga.push(errorCode);
        this.pushLocation(locator, ga);
        ga.push(isTypeError);
        ga.invokeStaticMethod(Callback.class, "makeXPathException", String.class, String.class, String.class, Integer.TYPE, Boolean.TYPE);
        ga.throwException();
    }

    public void generateParameterizedDynamicError(MessageBuilder builder, String errorCode, SourceLocator locator, boolean isTypeError) {
        Generator ga = this.getCurrentGenerator();
        builder.generateErrorMessage();
        ga.push(errorCode);
        this.pushLocation(locator, ga);
        ga.push(isTypeError);
        ga.invokeStaticMethod(Callback.class, "makeXPathException", String.class, String.class, String.class, Integer.TYPE, Boolean.TYPE);
        ga.throwException();
    }

    protected void pushLocation(SourceLocator locator, Generator ga) {
        if (locator != null) {
            ga.push(locator.getSystemId());
            ga.push(locator.getLineNumber());
        } else {
            ga.pushNull();
            ga.push(-1);
        }
    }

    public Class makeClass(ClassWriter writer, String className) {
        ClassVisitor cv = writer;
        cv = this.makeAnnotatedTraceClassVisitor(cv, className);
        if (!this.getCurrentClass().className.equals(className)) {
            throw new AssertionError((Object)(this.getCurrentClass().className + " != " + className));
        }
        for (StaticVariableInfo staticVar : this.getCurrentClass().staticVarsMap.values()) {
            cv.visitField(9, staticVar.name, Type.getType(staticVar.classVar).getDescriptor(), null, null).visitEnd();
        }
        cv.visitEnd();
        byte[] classFile = writer.toByteArray();
        if (this.myClassLoader == null) {
            this.myClassLoader = Version.platform.makeGeneratedClassLoader(this.config, this.getClass());
        }
        try {
            ((GeneratedClassLoader)this.myClassLoader).registerClass(className, classFile);
            Class<?> myClass = this.myClassLoader.loadClass(className);
            myClass.newInstance();
            for (StaticVariableInfo staticVar : this.getCurrentClass().staticVarsMap.values()) {
                try {
                    myClass.getField(staticVar.name).set(null, staticVar.object);
                }
                catch (NoSuchFieldException ex) {
                    System.out.println(staticVar.name + " NoSuchException error");
                    String classStr = new String(classFile, "UTF-8");
                    System.out.println(classStr);
                    throw new AssertionError((Object)ex);
                }
            }
            this.currentClasses.pop();
            return myClass;
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public StaticVariableInfo allocateStaticVariableInfo(Object value) {
        ObjectIdentityWrapper oiw = new ObjectIdentityWrapper(value);
        if (this.getCurrentClass().staticVarsMap.get(oiw) != null) {
            return this.getCurrentClass().staticVarsMap.get(oiw);
        }
        String name = value.getClass().getSimpleName();
        name = value.getClass().getSimpleName().endsWith("[]") ? "n" + name.substring(0, name.length() - 2) + CompilerService.getUniqueNumber() : "n" + name + CompilerService.getUniqueNumber();
        StaticVariableInfo staticVariableInfo = new StaticVariableInfo();
        staticVariableInfo.name = name;
        Class<?> staticClass = value.getClass();
        while (staticClass.getName().startsWith("gen_")) {
            staticClass = staticClass.getSuperclass();
        }
        staticVariableInfo.classVar = staticClass;
        staticVariableInfo.object = value;
        this.getCurrentClass().staticVarsMap.put(oiw, staticVariableInfo);
        return staticVariableInfo;
    }

    private void appendJavaName(String local, FastStringBuffer sb) {
        for (int i = 0; i < local.length(); ++i) {
            char c = local.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) {
                if (c == '/') {
                    sb.append("_Slash_");
                    continue;
                }
                sb.append('_');
                continue;
            }
            sb.append(c);
        }
    }

    public String makeValidJavaName(String name) {
        if ((name = name.replaceAll(" ", "")).length() > 256) {
            name = name.substring(0, 256);
        }
        FastStringBuffer sb = new FastStringBuffer(name.length());
        this.appendJavaName(name, sb);
        return sb.toString();
    }

    public ClassVisitor makeAnnotatedTraceClassVisitor(ClassVisitor cv, String className) {
        if (this.isDisplayByteCode()) {
            PrintWriter pw = this.createPrintWriter(className + ".txt");
            return new TraceClassVisitor(cv, pw);
        }
        return cv;
    }

    public AtomicTypeValidator compileAtomicValidator(UserAtomicType type, ConversionRules rules) throws CannotCompileException {
        this.checkMaxClassesLimit();
        String objectName = type.isAnonymousType() ? type.getDescription() : type.getTypeName().getDisplayName();
        try {
            AtomicTypeValidator gc;
            ClassWriter cw = new ClassWriter(this.flags);
            ClassVisitor cv = cw;
            String className = "TYPE_" + this.makeValidJavaName(objectName) + "_" + CompilerService.getUniqueNumber();
            cv = this.makeAnnotatedTraceClassVisitor(cv, className);
            cv.visit(49, 1, className, null, "com/saxonica/ee/bytecode/simtype/AtomicTypeValidator", new String[0]);
            this.pushNewClassInfo(className, GeneratedCode.class, cw);
            Method m = Method.getMethod("void <init> ()");
            Generator ga = new Generator(1, m, false, cv);
            ga.loadThis();
            ga.invokeConstructor(Type.getType(AtomicTypeValidator.class), m);
            ga.returnValue();
            ga.endMethod();
            m = Method.getMethod("net.sf.saxon.type.ValidationFailure validate(java.lang.CharSequence)");
            ga = new Generator(1, m, true, cv);
            this.pushNewMethodInfo(ga, false, 0);
            try {
                new AtomicTypeValidatorCompiler(type).compileAtomicValidator(this, rules);
            }
            catch (CannotCompileException e) {
                this.handleCodeGeneratorException(objectName, e);
                return null;
            }
            ga.returnValue();
            try {
                ga.endMethod();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("*** end method failed");
            }
            this.popCurrentMethodInfo();
            cv.visitEnd();
            ExpressionCompiler.verify(cw, objectName, this.isDebugByteCode());
            Class generated = this.makeClass(cw, className);
            try {
                gc = (AtomicTypeValidator)generated.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
                return null;
            }
            return gc;
        }
        catch (UnsupportedOperationException e) {
            if (this.isDebugByteCode()) {
                System.err.println("Cannot compile " + objectName + ": " + e.getMessage());
                e.printStackTrace(System.err);
            } else if (this.config.isTiming()) {
                this.config.getLogger().warning("Cannot compile " + objectName + "(" + e.getMessage() + ") - using interpreter");
            }
            this.currentClasses.pop();
            return null;
        }
        catch (ClassFormatError | RuntimeException | VerifyError e) {
            if (this.isDebugByteCode()) {
                System.err.println("Cannot compile " + objectName + ": " + e.getMessage());
                e.printStackTrace(System.err);
                throw e;
            }
            if (this.config.isTiming()) {
                this.config.getLogger().warning("Cannot compile " + objectName + "(" + e.getMessage() + ") - using interpreter");
            }
            this.currentClasses.pop();
            return null;
        }
    }

    public void checkMaxClassesLimit() throws CannotCompileException {
        if (classCounter++ > this.maxClasses) {
            throw new CannotCompileException("Too many compiled classes", true);
        }
    }

    static {
        expressionCompilers.put("ExistsCompiler", new ExistsCompiler());
        expressionCompilers.put("StringJoinCompiler", new StringJoinCompiler());
        expressionCompilers.put("RoundingCompiler", new RoundingCompiler());
        expressionCompilers.put("StringFnCompiler", new StringFnCompiler());
        expressionCompilers.put("ConcatCompiler", new ConcatCompiler());
        expressionCompilers.put("PositionCompiler", new PositionCompiler());
        expressionCompilers.put("LastCompiler", new LastCompiler());
        expressionCompilers.put("StartsWithCompiler", new StartsWithCompiler());
        expressionCompilers.put("AccessorFnCompiler", new AccessorFnCompiler());
        expressionCompilers.put("NameCompiler", new NameCompiler());
        expressionCompilers.put("LocalNameCompiler", new LocalNameCompiler());
        expressionCompilers.put("ContainsCompiler", new ContainsCompiler());
        expressionCompilers.put("ForceCaseCompiler", new ForceCaseCompiler());
        expressionCompilers.put("SubstringCompiler", new SubstringCompiler());
        expressionCompilers.put("StringLengthCompiler", new StringLengthCompiler());
        expressionCompilers.put("EmptyCompiler", new EmptyCompiler());
        expressionCompilers.put("CountCompiler", new CountCompiler());
        expressionCompilers.put("BooleanFnCompiler", new BooleanFnCompiler());
        expressionCompilers.put("NumberFnCompiler", new NumberFnCompiler());
        expressionCompilers.put("NormalizeSpaceCompiler", new NormalizeSpaceCompiler());
        expressionCompilers.put("NamespaceUriFnCompiler", new NamespaceUriFnCompiler());
        expressionCompilers.put("SubstringBeforeCompiler", new SubstringBeforeCompiler());
        expressionCompilers.put("NotFnCompiler", new NotFnCompiler());
        expressionCompilers.put("TranslateCompiler", new TranslateCompiler());
        expressionCompilers.put("GenerateIdCompiler", new GenerateIdCompiler());
        expressionCompilers.put("NodeNameFnCompiler", new NodeNameFnCompiler());
        expressionCompilers.put("RootFunctionCompiler", new RootFunctionCompiler());
        expressionCompilers.put("MatchesCompiler", new MatchesCompiler());
        expressionCompilers.put("SumCompiler", new SumCompiler());
        expressionCompilers.put("BaseURICompiler", new BaseURICompiler());
        expressionCompilers.put("DateTimeConstructorCompiler", new DateTimeConstructorCompiler());
        expressionCompilers.put("QNameFnCompiler", new QNameFnCompiler());
        expressionCompilers.put("SubstringAfterCompiler", new SubstringAfterCompiler());
        verifyErrors = 0;
    }

    public static class GeneratedClassInfo {
        String className;
        Class superclass;
        ClassWriter cw;
        HashMap<ObjectIdentityWrapper, StaticVariableInfo> staticVarsMap = new HashMap();

        public String getClassName() {
            return this.className;
        }

        public ClassWriter getClassWriter() {
            return this.cw;
        }

        public Class getSuperclass() {
            return this.superclass;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public void setSuperClass(Class superclass) {
            this.superclass = superclass;
        }

        public void setClassWriter(ClassWriter cw) {
            this.cw = cw;
        }

        public String getTypeDescriptor() {
            StringBuilder newBuffer = new StringBuilder("L");
            for (int i = 0; i < this.className.length(); ++i) {
                char c = this.className.charAt(i);
                newBuffer.append(c == '.' ? (char)'/' : (char)c);
            }
            newBuffer.append(';');
            return newBuffer.toString();
        }
    }

    private static class ObjectIdentityWrapper {
        private Object theObject;

        public ObjectIdentityWrapper(Object obj) {
            this.theObject = obj;
        }

        public Object getObject() {
            return this.theObject;
        }

        public int hashCode() {
            if (this.theObject instanceof IdentityComparable) {
                return ((IdentityComparable)this.theObject).identityHashCode();
            }
            return this.theObject.hashCode();
        }

        public boolean equals(Object o2) {
            if (o2 instanceof ObjectIdentityWrapper) {
                ObjectIdentityWrapper oiw2 = (ObjectIdentityWrapper)o2;
                if (oiw2.theObject.getClass() == this.theObject.getClass()) {
                    if (this.theObject instanceof IdentityComparable) {
                        if (!((IdentityComparable)oiw2.theObject).isIdentical((IdentityComparable)this.theObject)) {
                            return false;
                        }
                        if (this.theObject instanceof AtomicValue) {
                            return ((AtomicValue)this.theObject).getItemType().equals(((AtomicValue)oiw2.theObject).getItemType());
                        }
                        return true;
                    }
                    return oiw2.theObject.equals(this.theObject);
                }
            }
            return false;
        }
    }

    public static class StaticSubClasses {
        public String name;
        public Object object;
    }

    public static class StaticVariableInfo {
        public String name;
        public Class classVar;
        public Object object;
    }

    public class GeneratedExpression {
        ExpressionCompiler exprCompiler;
        Expression expr;

        public GeneratedExpression(ExpressionCompiler ec, Expression e) {
            this.exprCompiler = ec;
            this.expr = e;
        }

        public ExpressionCompiler getExpressionCompiler() {
            return this.exprCompiler;
        }

        public Expression getExpression() {
            return this.expr;
        }
    }
}

