/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ExpressionCompiler;
import com.saxonica.ee.bytecode.ToIteratorCompiler;
import com.saxonica.ee.bytecode.iter.OneToOneMappingIterator;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.MessageTemplate;
import com.saxonica.objectweb.asm.ClassVisitor;
import com.saxonica.objectweb.asm.ClassWriter;
import com.saxonica.objectweb.asm.Type;
import com.saxonica.objectweb.asm.commons.Method;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.NumericType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class ItemCheckerCompiler
extends ToIteratorCompiler {
    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        ItemChecker itemChecker = (ItemChecker)expression;
        Expression operand = itemChecker.getBaseExpression();
        compiler.compileToItem(operand);
        ItemCheckerCompiler.visitLineNumber(compiler, ga, expression);
        boolean allowEmpty = Cardinality.allowsZero(operand.getCardinality());
        LabelInfo ok = null;
        if (allowEmpty) {
            ok = methodInfo.newLabel("ok");
            ga.dup();
            ga.ifNull(ok.label());
        }
        ItemType requiredType = itemChecker.getRequiredType();
        RoleDiagnostic role = itemChecker.getRoleLocator();
        this.generateItemCheck(compiler, ga, requiredType, role, expression.getLocation());
        if (ok != null) {
            methodInfo.placeLabel(ok);
        }
    }

    @Override
    public void compileToIterator(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        ItemCheckerCompiler.visitAnnotation(compiler, "ItemCheckerCompiler");
        Class checkingIterator = compiler.getCompiledClass(expression);
        if (checkingIterator == null) {
            checkingIterator = this.generateItemCheckingIterator(compiler, (ItemChecker)expression);
            compiler.setCompiledClass(expression, checkingIterator);
        }
        ExpressionCompiler.allocateStatic(compiler, checkingIterator);
        ga.invokeInstanceMethod(Class.class, "newInstance", new Class[0]);
        ga.checkClass(OneToOneMappingIterator.class);
        ga.dup();
        compiler.compileToIterator(((ItemChecker)expression).getBaseExpression());
        ItemCheckerCompiler.visitLineNumber(compiler, ga, expression);
        compiler.generateGetContext();
        ga.invokeInstanceMethod(OneToOneMappingIterator.class, "setSequence", SequenceIterator.class, XPathContext.class);
    }

    private Class generateItemCheckingIterator(CompilerService compiler, ItemChecker expression) throws CannotCompileException {
        compiler.checkMaxClassesLimit();
        ItemType requiredType = expression.getRequiredType();
        RoleDiagnostic role = expression.getRoleLocator();
        ClassWriter cw = new ClassWriter(compiler.getFlags());
        ClassVisitor cv = cw;
        String className = "ItemCheckingIterator_" + compiler.getUniqueNumber();
        cv = compiler.makeAnnotatedTraceClassVisitor(cv, className);
        cv.visitSource(expression.getLocation().getSystemId(), null);
        cv.visit(49, 1, "gen/" + className, null, "com/saxonica/ee/bytecode/iter/OneToOneMappingIterator", new String[0]);
        compiler.pushNewClassInfo("gen." + className, OneToOneMappingIterator.class, cw);
        Method m = Method.getMethod("void <init> ()");
        Generator ga = new Generator(1, m, false, cv);
        ga.loadThis();
        ga.invokeConstructor(Type.getType(OneToOneMappingIterator.class), m);
        ga.returnValue();
        ga.endMethod();
        m = Method.getMethod("net.sf.saxon.om.Item map(net.sf.saxon.om.Item)");
        ga = new Generator(1, m, true, cv);
        int contextVar = ga.newLocal(XPathContext.class);
        compiler.pushNewMethodInfo(ga, false, contextVar);
        ItemCheckerCompiler.visitLineNumber(compiler, ga, expression);
        ga.loadThis();
        ga.getField(Type.getType(OneToOneMappingIterator.class), "context", Type.getType(XPathContext.class));
        compiler.initNewMethod(ga, false);
        ga.loadArg(0);
        this.generateItemCheck(compiler, ga, requiredType, role, expression.getLocation());
        ga.returnValue();
        try {
            ga.endMethod();
        }
        catch (Exception err) {
            System.err.println("**** endMethod failed");
        }
        compiler.popCurrentMethodInfo();
        cv.visitEnd();
        ItemCheckerCompiler.verify(cw, "Item checker at line " + expression.getLocation().getLineNumber(), compiler.isDebugByteCode());
        return compiler.makeClass(cw, "gen." + className);
    }

    private void generateItemCheck(CompilerService compiler, Generator ga, ItemType requiredType, RoleDiagnostic role, SourceLocator locator) {
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        LabelInfo ok = methodInfo.newLabel("ok");
        LabelInfo errorLab = null;
        ga.dup();
        if (requiredType == AnyNodeTest.getInstance()) {
            ga.instanceOf(Type.getType(NodeInfo.class));
        } else if (requiredType.equals(BuiltInAtomicType.ANY_ATOMIC)) {
            ga.instanceOf(Type.getType(AtomicValue.class));
        } else if (requiredType.equals(BuiltInAtomicType.STRING)) {
            errorLab = methodInfo.newLabel("errorLab");
            ga.dup();
            ga.instanceOf(Type.getType(StringValue.class));
            ga.swap();
            ga.instanceOf(Type.getType(UntypedAtomicValue.class));
            ga.not();
            ga.ifICmp(153, ok.label());
            ga.goTo(errorLab);
        } else if (requiredType.equals(NumericType.getInstance())) {
            ga.instanceOf(Type.getType(NumericValue.class));
        } else if (requiredType.equals(BuiltInAtomicType.DOUBLE)) {
            ga.instanceOf(Type.getType(DoubleValue.class));
        } else if (requiredType.equals(BuiltInAtomicType.FLOAT)) {
            ga.instanceOf(Type.getType(FloatValue.class));
        } else if (requiredType.equals(BuiltInAtomicType.INTEGER)) {
            ga.instanceOf(Type.getType(IntegerValue.class));
        } else if (requiredType.equals(BuiltInAtomicType.BOOLEAN)) {
            ga.instanceOf(Type.getType(BooleanValue.class));
        } else {
            ExpressionCompiler.allocateStatic(compiler, requiredType);
            ga.swap();
            Configuration config = compiler.getConfiguration();
            TypeHierarchy th = config.getTypeHierarchy();
            ItemCheckerCompiler.allocateStatic(compiler, th);
            ga.invokeInstanceMethod(ItemType.class, "matches", Item.class, TypeHierarchy.class);
        }
        ga.ifTrue(ok);
        if (errorLab != null) {
            methodInfo.placeLabel(errorLab);
        }
        String msg = role.composeRequiredMessage(requiredType);
        ga.dup();
        ga.invokeStaticMethod(net.sf.saxon.type.Type.class, "displayTypeName", Item.class);
        compiler.generateParameterizedDynamicError(new MessageTemplate(ga, msg + "; actual type is {$1}", -1), role.getErrorCode(), locator, true);
        methodInfo.placeLabel(ok);
    }
}

