/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToStringCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.OnEmpty;
import com.saxonica.objectweb.asm.Type;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.functions.StringJoin;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.StringValue;

public class StringJoinCompiler
extends ToStringCompiler {
    @Override
    public void compileToPush(CompilerService compiler, Expression expression) throws CannotCompileException {
        SystemFunctionCall fnc = (SystemFunctionCall)expression;
        Expression expr0 = fnc.getArg(0);
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        StringJoinCompiler.visitAnnotation(compiler, "StringJoin-push");
        LabelInfo notInstanceOf = methodInfo.newLabel("notInstanceOf");
        LabelInfo end = methodInfo.newLabel("endSJ");
        LabelInfo notNull = methodInfo.newLabel("strJnotNull");
        compiler.generateGetReceiver();
        ga.ifNotInstance(ComplexContentOutputter.class, notInstanceOf);
        compiler.generateGetReceiver();
        ga.getStaticField(StringValue.class, "EMPTY_STRING", StringValue.class);
        StringJoinCompiler.allocateStatic(compiler, expression.getLocation());
        ga.push(0);
        ga.invokeInstanceMethod(Receiver.class, "append", Item.class, Location.class, Integer.TYPE);
        StringJoinCompiler.visitAnnotation(compiler, "StringJoin-iterate-first-arg-enter");
        compiler.compileToIterator(expr0);
        StringJoinCompiler.visitAnnotation(compiler, "StringJoin-iterate-first-arg-exit");
        int iterVar = methodInfo.allocateLocal(SequenceIterator.class);
        ga.storeLocal(iterVar);
        StringJoinCompiler.visitLineNumber(compiler, ga, expression);
        ga.loadLocal(iterVar);
        ga.showObject(compiler, "SequenceIterator (SJ arg 0) A: ");
        ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
        int itVar = methodInfo.allocateLocal(Item.class);
        ga.storeLocal(itVar);
        ga.loadLocal(itVar);
        ga.ifNull(end.label());
        ga.loadLocal(itVar);
        StringJoinCompiler.visitAnnotation(compiler, "StringJoin-process-first");
        ga.invokeInstanceMethod(Item.class, "getStringValueCS", new Class[0]);
        int firstVar = methodInfo.allocateLocal(CharSequence.class);
        ga.storeLocal(firstVar);
        compiler.generateGetReceiver();
        ga.loadLocal(firstVar);
        StringJoinCompiler.allocateStatic(compiler, expression.getLocation());
        ga.push(0);
        ga.invokeInstanceMethod(Receiver.class, "characters", CharSequence.class, Location.class, Integer.TYPE);
        ga.loadLocal(iterVar);
        ga.showObject(compiler, "SequenceIterator (SJ arg 0) B: ");
        ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
        ga.storeLocal(itVar);
        ga.loadLocal(itVar);
        ga.ifNonNull(notNull.label());
        StringJoinCompiler.visitAnnotation(compiler, "StringJoin-second-item-is-null");
        compiler.generateGetReceiver();
        ga.getStaticField(StringValue.class, "EMPTY_STRING", StringValue.class);
        StringJoinCompiler.allocateStatic(compiler, expression.getLocation());
        ga.push(0);
        ga.invokeInstanceMethod(Receiver.class, "append", Item.class, Location.class, Integer.TYPE);
        ga.goTo(end);
        methodInfo.placeLabel(notNull);
        StringJoinCompiler.visitAnnotation(compiler, "StringJoin-process-second");
        if (fnc.getArity() == 1) {
            ga.loadLocal(itVar);
            ga.invokeInstanceMethod(Item.class, "getStringValueCS", new Class[0]);
            compiler.generateGetReceiver();
            ga.swap();
            StringJoinCompiler.allocateStatic(compiler, expression.getLocation());
            ga.push(0);
            ga.invokeInstanceMethod(Receiver.class, "characters", CharSequence.class, Location.class, Integer.TYPE);
            LabelInfo loop = methodInfo.placeNewLabel("loop");
            ga.loadLocal(iterVar);
            ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
            ga.storeLocal(itVar);
            ga.loadLocal(itVar);
            ga.ifNull(end.label());
            StringJoinCompiler.visitAnnotation(compiler, "StringJoin-process-next");
            ga.loadLocal(itVar);
            ga.invokeInstanceMethod(Item.class, "getStringValueCS", new Class[0]);
            compiler.generateGetReceiver();
            ga.swap();
            StringJoinCompiler.allocateStatic(compiler, expression.getLocation());
            ga.push(0);
            ga.invokeInstanceMethod(Receiver.class, "characters", CharSequence.class, Location.class, Integer.TYPE);
            ga.goTo(loop);
        } else {
            compiler.compileToPrimitive(fnc.getArg(1), CharSequence.class, OnEmpty.RETURN_EMPTY_STRING);
            StringJoinCompiler.visitAnnotation(compiler, "StringJoin-push-else");
            int sepVar = methodInfo.allocateLocal(CharSequence.class);
            ga.storeLocal(sepVar);
            compiler.generateGetReceiver();
            ga.loadLocal(sepVar);
            StringJoinCompiler.allocateStatic(compiler, expression.getLocation());
            ga.push(0);
            ga.invokeInstanceMethod(Receiver.class, "characters", CharSequence.class, Location.class, Integer.TYPE);
            compiler.generateGetReceiver();
            ga.loadLocal(itVar);
            ga.invokeInstanceMethod(Item.class, "getStringValueCS", new Class[0]);
            StringJoinCompiler.allocateStatic(compiler, expression.getLocation());
            ga.push(0);
            ga.invokeInstanceMethod(Receiver.class, "characters", CharSequence.class, Location.class, Integer.TYPE);
            LabelInfo loop = methodInfo.placeNewLabel("loop");
            ga.loadLocal(iterVar);
            ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
            ga.storeLocal(itVar);
            ga.loadLocal(itVar);
            ga.ifNull(end.label());
            compiler.generateGetReceiver();
            ga.loadLocal(sepVar);
            StringJoinCompiler.allocateStatic(compiler, expression.getLocation());
            ga.push(0);
            ga.invokeInstanceMethod(Receiver.class, "characters", CharSequence.class, Location.class, Integer.TYPE);
            compiler.generateGetReceiver();
            ga.loadLocal(itVar);
            ga.invokeInstanceMethod(Item.class, "getStringValueCS", new Class[0]);
            StringJoinCompiler.allocateStatic(compiler, expression.getLocation());
            ga.push(0);
            ga.invokeInstanceMethod(Receiver.class, "characters", CharSequence.class, Location.class, Integer.TYPE);
            ga.goTo(loop);
            methodInfo.releaseLocal(sepVar);
        }
        methodInfo.placeLabel(notInstanceOf);
        compiler.generateGetReceiver();
        this.compileToItem(compiler, expression);
        StringJoinCompiler.allocateStatic(compiler, expression.getLocation());
        ga.push(0);
        ga.invokeInstanceMethod(Receiver.class, "append", Item.class, Location.class, Integer.TYPE);
        methodInfo.placeLabel(end);
        methodInfo.releaseLocal(iterVar);
        methodInfo.releaseLocal(itVar);
        methodInfo.releaseLocal(firstVar);
    }

    @Override
    public void compileToPrimitive(CompilerService compiler, Expression expression, Class requiredClass, OnEmpty onEmpty) throws CannotCompileException {
        SystemFunctionCall fnc = (SystemFunctionCall)expression;
        Expression expr0 = fnc.getArg(0);
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        StringJoinCompiler.visitAnnotation(compiler, "StringJoin-Item");
        LabelInfo end = methodInfo.newLabel("endSJ");
        LabelInfo notNull = methodInfo.newLabel("strJnotNull");
        LabelInfo notNull2 = methodInfo.newLabel("strJnotNull2");
        compiler.compileToIterator(expr0);
        StringJoinCompiler.visitLineNumber(compiler, ga, expression);
        StringJoinCompiler.visitAnnotation(compiler, "StringJoin-Item-1");
        int iterVar = methodInfo.allocateLocal(SequenceIterator.class);
        ga.storeLocal(iterVar);
        ga.loadLocal(iterVar);
        ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
        ga.dup();
        ga.ifNonNull(notNull.label());
        ga.pop();
        if (((StringJoin)fnc.getTargetFunction()).isReturnEmptyIfEmpty()) {
            onEmpty.generate(ga);
        } else {
            ga.push("");
        }
        ga.goTo(end);
        methodInfo.placeLabel(notNull);
        ga.invokeInstanceMethod(Item.class, "getStringValueCS", new Class[0]);
        int firstVar = methodInfo.allocateLocal(CharSequence.class);
        ga.storeLocal(firstVar);
        ga.loadLocal(iterVar);
        ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
        ga.dup();
        ga.ifNonNull(notNull2.label());
        ga.pop();
        ga.loadLocal(firstVar);
        ga.goTo(end);
        methodInfo.placeLabel(notNull2);
        ga.newInstance(Type.getType(FastStringBuffer.class));
        ga.dup();
        ga.push(64);
        ga.invokeConstructor(FastStringBuffer.class, Integer.TYPE);
        int sbVar = methodInfo.allocateLocal(FastStringBuffer.class);
        ga.storeLocal(sbVar);
        ga.loadLocal(sbVar);
        ga.loadLocal(firstVar);
        ga.invokeInstanceMethod(FastStringBuffer.class, "append", CharSequence.class);
        LabelInfo done = methodInfo.newLabel("doneSJ");
        int sepVar = -1;
        if (fnc.getArity() == 1) {
            ga.loadLocal(sbVar);
            ga.swap();
            ga.invokeInstanceMethod(Item.class, "getStringValueCS", new Class[0]);
            ga.invokeInstanceMethod(FastStringBuffer.class, "append", CharSequence.class);
        } else {
            compiler.compileToPrimitive(((SystemFunctionCall)expression).getArg(1), CharSequence.class, OnEmpty.RETURN_EMPTY_STRING);
            sepVar = methodInfo.allocateLocal(CharSequence.class);
            ga.storeLocal(sepVar);
            ga.loadLocal(sbVar);
            ga.loadLocal(sepVar);
            ga.invokeInstanceMethod(FastStringBuffer.class, "append", CharSequence.class);
            ga.loadLocal(sbVar);
            ga.swap();
            ga.invokeInstanceMethod(Item.class, "getStringValueCS", new Class[0]);
            ga.invokeInstanceMethod(FastStringBuffer.class, "append", CharSequence.class);
        }
        LabelInfo loop = methodInfo.placeNewLabel("loop");
        ga.loadLocal(iterVar);
        ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
        ga.dup();
        ga.ifNull(done.label());
        ga.loadLocal(sbVar);
        if (sepVar >= 0) {
            ga.loadLocal(sepVar);
            ga.invokeInstanceMethod(FastStringBuffer.class, "append", CharSequence.class);
            ga.loadLocal(sbVar);
        }
        ga.swap();
        ga.invokeInstanceMethod(Item.class, "getStringValueCS", new Class[0]);
        ga.invokeInstanceMethod(FastStringBuffer.class, "append", CharSequence.class);
        ga.goTo(loop);
        methodInfo.placeLabel(done);
        ga.pop();
        ga.loadLocal(sbVar);
        ga.invokeInstanceMethod(FastStringBuffer.class, "condense", new Class[0]);
        methodInfo.placeLabel(end);
        methodInfo.releaseLocal(iterVar);
        methodInfo.releaseLocal(sbVar);
        methodInfo.releaseLocal(sepVar);
        if (requiredClass == String.class) {
            ga.invokeInstanceMethod(Object.class, "toString", new Class[0]);
        }
    }
}

