/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import com.saxonica.ee.schema.UserSimpleType;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Genre;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.StringToDouble;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.type.UnionType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;

public class NumericType
implements UnionType,
PlainType {
    private static final NumericType THE_INSTANCE = new NumericType();
    private List<PlainType> members;

    public static NumericType getInstance() {
        return THE_INSTANCE;
    }

    private NumericType() {
    }

    @Override
    public StructuredQName getTypeName() {
        return new StructuredQName("xs", "http://www.w3.org/2001/XMLSchema", "numeric");
    }

    @Override
    public Genre getGenre() {
        return Genre.ATOMIC;
    }

    @Override
    public String getAlphaCode() {
        return "A";
    }

    @Override
    public boolean containsListType() {
        return false;
    }

    @Override
    public synchronized Iterable<PlainType> getPlainMemberTypes() {
        if (this.members == null) {
            this.members = new ArrayList<PlainType>();
            this.members.add(BuiltInAtomicType.DOUBLE);
            this.members.add(BuiltInAtomicType.FLOAT);
            this.members.add(BuiltInAtomicType.DECIMAL);
        }
        return this.members;
    }

    @Override
    public SequenceType getResultTypeOfCast() {
        return SequenceType.ATOMIC_SEQUENCE;
    }

    @Override
    public boolean isPlainType() {
        return true;
    }

    @Override
    public boolean matches(Item item, TypeHierarchy th) {
        return item instanceof NumericValue;
    }

    @Override
    public AtomicType getPrimitiveItemType() {
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    @Override
    public int getPrimitiveType() {
        return BuiltInAtomicType.ANY_ATOMIC.getFingerprint();
    }

    @Override
    public UType getUType() {
        return UType.NUMERIC;
    }

    @Override
    public PlainType getAtomizedItemType() {
        return this;
    }

    @Override
    public boolean isAtomizable(TypeHierarchy th) {
        return true;
    }

    @Override
    public boolean isAtomicType() {
        return false;
    }

    @Override
    public boolean isListType() {
        return false;
    }

    @Override
    public boolean isUnionType() {
        return true;
    }

    @Override
    public boolean isExternalType() {
        return false;
    }

    @Override
    public boolean isBuiltInType() {
        return true;
    }

    @Override
    public SchemaType getBuiltInBaseType() {
        return AnySimpleType.getInstance();
    }

    @Override
    public AtomicSequence getTypedValue(CharSequence value, NamespaceResolver resolver, ConversionRules rules) throws ValidationException {
        try {
            double d = StringToDouble.getInstance().stringToNumber(value);
            return new DoubleValue(d);
        }
        catch (NumberFormatException e) {
            throw new ValidationFailure(e.getMessage()).makeException();
        }
    }

    @Override
    public ValidationFailure validateContent(CharSequence value, NamespaceResolver nsResolver, ConversionRules rules) {
        try {
            StringToDouble.getInstance().stringToNumber(value);
            return null;
        }
        catch (NumberFormatException e) {
            return new ValidationFailure(e.getMessage());
        }
    }

    @Override
    public ValidationFailure checkAgainstFacets(AtomicValue value, ConversionRules rules) {
        return null;
    }

    @Override
    public boolean isNamespaceSensitive() {
        return false;
    }

    @Override
    public int getWhitespaceAction() {
        return 2;
    }

    @Override
    public CharSequence preprocess(CharSequence input) {
        return input;
    }

    @Override
    public CharSequence postprocess(CharSequence input) {
        return input;
    }

    @Override
    public String getName() {
        return "numeric";
    }

    @Override
    public String getTargetNamespace() {
        return "http://www.w3.org/2001/XMLSchema";
    }

    @Override
    public int getFingerprint() {
        return 635;
    }

    @Override
    public String getDisplayName() {
        return "xs:numeric";
    }

    @Override
    public String getEQName() {
        return "Q(http://www.w3.org/2001/XMLSchema}numeric";
    }

    @Override
    public StructuredQName getStructuredQName() {
        return new StructuredQName("xs", "http://www.w3.org/2001/XMLSchema", "numeric");
    }

    @Override
    public boolean isComplexType() {
        return false;
    }

    @Override
    public boolean isSimpleType() {
        return true;
    }

    @Override
    public boolean isAnonymousType() {
        return false;
    }

    @Override
    public int getBlock() {
        return 0;
    }

    @Override
    public SchemaType getBaseType() {
        return AnySimpleType.getInstance();
    }

    @Override
    public int getDerivationMethod() {
        return 1;
    }

    @Override
    public int getFinalProhibitions() {
        return 0;
    }

    @Override
    public boolean allowsDerivation(int derivation) {
        return true;
    }

    @Override
    public void analyzeContentExpression(Expression expression, int kind) throws XPathException {
        BuiltInAtomicType.analyzeContentExpression(this, expression, kind);
    }

    @Override
    public AtomicSequence atomize(NodeInfo node) throws XPathException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSameType(SchemaType other) {
        return other instanceof NumericType;
    }

    @Override
    public String getDescription() {
        return "xs:numeric";
    }

    @Override
    public String getSystemId() {
        return null;
    }

    @Override
    public boolean isIdType() {
        return false;
    }

    @Override
    public boolean isIdRefType() {
        return false;
    }

    @Override
    public SchemaComponent.ValidationStatus getValidationStatus() {
        return SchemaComponent.ValidationStatus.VALIDATED;
    }

    @Override
    public int getRedefinitionLevel() {
        return 0;
    }

    @Override
    public String toExportString() {
        return this.toString();
    }

    @Override
    public String toString() {
        return "xs:numeric";
    }

    @Override
    public String generateJavaScriptItemTypeTest(ItemType knownToBe, int targetVersion) {
        if (targetVersion == 1) {
            return "return SaxonJS.U.Atomic.numeric.matches(item);";
        }
        return "return SaxonJS.U.isNumeric(item);";
    }

    @Override
    public String generateJavaScriptItemTypeAcceptor(String errorCode, int targetVersion) throws XPathException {
        return BuiltInAtomicType.DOUBLE.generateJavaScriptItemTypeAcceptor(errorCode, targetVersion);
    }

    @Override
    public void checkTypeDerivationIsOK(SchemaType base, int block) throws SchemaException {
        String s = UserSimpleType.isTypeDerivationOK(this, base, block);
        if (s != null) {
            throw new SchemaException(s);
        }
    }

    @Override
    public Function getComponentAsFunction() {
        return UserSimpleType.getComponentAsFunction(this);
    }
}

