/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.ee.schema.ExplicitTimezoneFacet;
import com.saxonica.ee.schema.Facet;
import com.saxonica.ee.schema.PatternFacet;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.sdoc.AnnotationParent;
import java.util.ArrayList;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.type.SchemaException;

public class XSDFacet
extends AnnotationParent {
    private Facet facet = null;

    @Override
    public void prepareAttributes() throws SchemaException {
        String[] allowed;
        AttributeCollection atts = this.getAttributeList();
        if (this.getLocalPart().equals("enumeration") || this.getLocalPart().equals("pattern")) {
            allowed = new String[]{"id", "value"};
            this.allowAttributes(atts, allowed);
        } else {
            allowed = new String[]{"fixed", "id", "value"};
            this.allowAttributes(atts, allowed);
        }
        String value = atts.getValue("", "value");
        if (value == null) {
            this.missingAttribute("value");
            value = "";
        }
        try {
            this.facet = Facet.makeFacet(this.getLocalPart(), value, this.getSchema().getConfiguration(), this.makeNamespaceContext(), this.getXSDSchema().getSchemaCompiler());
        }
        catch (SchemaException err) {
            this.error(err.getMessage());
            return;
        }
        String message = atts.getValue("http://saxon.sf.net/", "message");
        if (message != null) {
            this.facet.setMessage(message);
        }
        if (this.facet instanceof PatternFacet) {
            String flags = atts.getValue("http://saxon.sf.net/", "flags");
            if (flags != null) {
                ((PatternFacet)this.facet).setFlags(flags);
            }
            ArrayList<String> warnings = new ArrayList<String>();
            try {
                ((PatternFacet)this.facet).compile(warnings);
            }
            catch (SchemaException e) {
                this.error(e.getMessage());
            }
            for (String s : warnings) {
                this.warning(s);
            }
        }
        String fixedAtt = atts.getValue("", "fixed");
        boolean fixed = false;
        if (fixedAtt != null) {
            fixed = this.parseBooleanAttribute("fixed", fixedAtt);
        }
        this.facet.setFixed(fixed);
        this.processId();
    }

    @Override
    public void validate(SchemaCompiler compiler) throws SchemaException {
        super.validate(compiler);
        if (compiler.getLanguageVersion() == 10 && this.facet instanceof ExplicitTimezoneFacet) {
            this.error("Timezone facet requires XSD 1.1 to be enabled");
        }
    }

    public Facet getFacet() {
        return this.facet;
    }
}

