/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.functions.TreatFn;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.Cardinality;

public class CardinalityCheckingFeed
extends ItemFeed {
    private int count = 0;
    private int requiredCardinality;
    private RoleDiagnostic role;

    public CardinalityCheckingFeed(Expression checker, Feed result, XPathContext context) {
        super(checker, result, context);
        if (checker instanceof CardinalityChecker) {
            this.requiredCardinality = ((CardinalityChecker)checker).getRequiredCardinality();
            this.role = ((CardinalityChecker)checker).getRoleLocator();
        } else if (checker.isCallOn(TreatFn.class)) {
            TreatFn fn = (TreatFn)((SystemFunctionCall)checker).getTargetFunction();
            this.requiredCardinality = fn.getRequiredCardinality();
            this.role = fn.makeRoleDiagnostic();
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
        if (!this.hasFailed()) {
            this.checkCount();
            return this.getResult().startSelectedParentNode(node, locationId);
        }
        return null;
    }

    @Override
    public void endSelectedParentNode(Location locationId) throws XPathException {
        if (!this.hasFailed()) {
            this.getResult().endSelectedParentNode(locationId);
        }
    }

    @Override
    public void processItem(Item<?> item) throws XPathException {
        if (!this.hasFailed()) {
            this.checkCount();
            this.getResult().processItem(item);
        }
    }

    private void checkCount() throws XPathException {
        if (!this.hasFailed() && this.count <= 2) {
            ++this.count;
            if (this.count == 1 && this.requiredCardinality == 8192) {
                this.typeError("The only value allowed for the " + this.role.getMessage() + " is an empty sequence", this.role.getErrorCode());
            } else if (this.count == 2 && !Cardinality.allowsMany(this.requiredCardinality)) {
                this.typeError("A sequence of more than one item is not allowed as the " + this.role.getMessage(), this.role.getErrorCode());
            }
        }
    }

    @Override
    public void close() throws XPathException {
        if (!this.hasFailed()) {
            if (this.count == 0 && !Cardinality.allowsZero(this.requiredCardinality)) {
                this.typeError("An empty sequence is not allowed as the " + this.role.getMessage(), this.role.getErrorCode());
                return;
            }
            this.getResult().close();
        }
    }

    private void typeError(String message, String errorCode) throws XPathException {
        XPathException e = new XPathException(message, errorCode, this.getExpression().getLocation());
        e.setIsTypeError(this.getExpression() instanceof CardinalityChecker);
        this.dynamicError(e);
    }

    @Override
    public SequenceReceiver getReceiver() {
        Receiver next = this.getResult().getReceiver();
        return new ProxyReceiver(next){
            int level;
            {
                this.level = 0;
            }

            @Override
            public void startDocument(int properties) throws XPathException {
                if (this.level++ == 0) {
                    CardinalityCheckingFeed.this.checkCount();
                }
                super.startDocument(properties);
            }

            @Override
            public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
                if (!CardinalityCheckingFeed.this.hasFailed()) {
                    if (this.level++ == 0) {
                        CardinalityCheckingFeed.this.checkCount();
                    }
                    super.startElement(elemName, typeCode, location, properties);
                }
            }

            @Override
            public void endElement() throws XPathException {
                if (!CardinalityCheckingFeed.this.hasFailed()) {
                    --this.level;
                    super.endElement();
                }
            }

            @Override
            public void endDocument() throws XPathException {
                --this.level;
                super.endDocument();
            }

            @Override
            public void namespace(NamespaceBindingSet namespaceBindings, int properties) throws XPathException {
                if (this.level == 0) {
                    CardinalityCheckingFeed.this.checkCount();
                }
                super.namespace(namespaceBindings, properties);
            }

            @Override
            public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value, Location locationId, int properties) throws XPathException {
                if (this.level == 0) {
                    CardinalityCheckingFeed.this.checkCount();
                }
                super.attribute(nameCode, typeCode, value, locationId, properties);
            }

            @Override
            public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
                if (this.level == 0) {
                    CardinalityCheckingFeed.this.checkCount();
                }
                super.characters(chars, locationId, properties);
            }

            @Override
            public void processingInstruction(String target, CharSequence data, Location locationId, int properties) throws XPathException {
                if (this.level == 0) {
                    CardinalityCheckingFeed.this.checkCount();
                }
                super.processingInstruction(target, data, locationId, properties);
            }

            @Override
            public void comment(CharSequence chars, Location locationId, int properties) throws XPathException {
                if (this.level == 0) {
                    CardinalityCheckingFeed.this.checkCount();
                }
                super.comment(chars, locationId, properties);
            }

            @Override
            public void append(Item item, Location locationId, int properties) throws XPathException {
                if (this.level == 0) {
                    CardinalityCheckingFeed.this.checkCount();
                }
                super.append(item, locationId, properties);
            }
        };
    }
}

