/*
 * Decompiled with CFR 0.152.
 */
package marmot.tokenize.preprocess;

import marmot.util.LevenshteinLattice;

public class Pair {
    public String tokenized;
    public String untokenized;
    public double score;

    public Pair(String tokenized, String untokenized) {
        this.tokenized = tokenized;
        this.untokenized = untokenized;
        LevenshteinLattice lattice = new LevenshteinLattice(untokenized, tokenized);
        this.score = (double)lattice.getDistance() / (double)(untokenized.length() + tokenized.length());
    }

    public String toString() {
        return "Pair [tokenized=" + this.tokenized + ", untokenized=" + this.untokenized + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tokenized == null ? 0 : this.tokenized.hashCode());
        result = 31 * result + (this.untokenized == null ? 0 : this.untokenized.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pair other = (Pair)obj;
        if (this.tokenized == null ? other.tokenized != null : !this.tokenized.equals(other.tokenized)) {
            return false;
        }
        return !(this.untokenized == null ? other.untokenized != null : !this.untokenized.equals(other.untokenized));
    }
}

