/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import com.saxonica.ee.schema.AttributeDecl;
import com.saxonica.ee.schema.ElementDecl;
import com.saxonica.ee.schema.UserAtomicType;
import com.saxonica.ee.schema.ValueConstraint;
import com.saxonica.ee.validate.ContentValidator;
import java.util.ArrayList;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;

public class LaxValidator
extends ContentValidator {
    public LaxValidator(Receiver next) {
        super(next);
    }

    @Override
    public SchemaType getSchemaType() {
        return null;
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        int fp = elemName.obtainFingerprint(this.getNamePool());
        ElementDecl decl = (ElementDecl)this.getConfiguration().getElementDeclaration(fp);
        this.makeChildValidator(decl, elemName.getStructuredQName(), location, 2);
        this.checkNoChildrenWhenNil(location);
        ArrayList<AttributeInfo> attList = new ArrayList<AttributeInfo>(attributes.size());
        for (AttributeInfo att : attributes) {
            attList.add(this.processAttribute(att));
        }
        AttributeMap validatedAtts = SequenceTool.attributeMapFromList(attList);
        type = this.childValidator.getAnnotation();
        super.startElement(elemName, type, validatedAtts, namespaces, location, properties);
    }

    @Override
    protected ContentValidator getChildValidator() {
        return this.childValidator;
    }

    protected AttributeInfo processAttribute(AttributeInfo att) throws XPathException {
        String value = att.getValue();
        SimpleType annotation = BuiltInAtomicType.UNTYPED_ATOMIC;
        AttributeDecl decl = (AttributeDecl)this.getConfiguration().getAttributeDeclaration(att.getNodeName().getStructuredQName());
        if (decl != null) {
            SimpleType type = decl.getSimpleType();
            ValidationFailure err = type.validateContent(StringView.of(att.getValue()).tidy(), this.getNamespaceResolver(), this.getConfiguration().getConversionRules());
            if (err != null) {
                err.setConstraintReference(1, "cvc-complex-type", "3");
                err.setSchemaType(type);
                this.reportValidationError(err, false, att.getLocation());
            } else {
                if (type instanceof UserAtomicType) {
                    value = ((UserAtomicType)type).getSharedInstance(value);
                }
                annotation = type;
                ValueConstraint constraint = decl.getFixedValueConstraint();
                if (constraint != null && !constraint.testFixedValue(this.getConfiguration(), StringView.of(value).tidy(), type, this.getNamespaceResolver())) {
                    AtomicSequence fixed = decl.getFixedValue();
                    String message = "The actual value " + Err.wrap(value, 4) + " of attribute " + Err.wrap(att.getNodeName().getDisplayName(), 2) + " does not match the required fixed value " + (fixed instanceof AtomicValue ? Err.wrap(fixed.getUnicodeStringValue(), 4) : "");
                    ValidationFailure ve = new ValidationFailure(message);
                    ve.setConstraintReference(1, "cvc-au", "0");
                    ve.setSchemaType(type);
                    this.reportValidationError(ve, false, att.getLocation());
                }
            }
        }
        return new AttributeInfo(att.getNodeName(), annotation, value, att.getLocation(), att.getProperties());
    }

    @Override
    public void characters(UnicodeString chars, Location locationId, int properties) throws XPathException {
        this.checkNoCharactersWhenNil(locationId);
        super.characters(chars, locationId, properties);
    }
}

