/*
 * Decompiled with CFR 0.152.
 */
package chipmunk.segmenter;

import chipmunk.segmenter.StringNormalizer;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import marmot.util.LineIterator;

public class Dictionary
implements Serializable {
    private static final long serialVersionUID = 1L;
    private StringNormalizer normalizer_;
    private Set<String> set_;
    private int min_count_ = 5;

    public Dictionary(String path, String lang, int max_length) {
        this.normalizer_ = StringNormalizer.rawCreate(lang);
        this.init(path, max_length);
    }

    private void init(String path, int max_length) {
        this.set_ = new HashSet<String>();
        LineIterator iterator2 = new LineIterator(path);
        while (iterator2.hasNext()) {
            int count2;
            String segment;
            Object line = iterator2.next();
            assert (line.size() == 1 || line.size() == 2) : line;
            if (line.size() == 2) {
                segment = (String)line.get(1);
                count2 = Integer.parseInt((String)line.get(0));
            } else {
                segment = (String)line.get(0);
                count2 = this.min_count_;
            }
            if (count2 < this.min_count_ || (segment = this.normalizer_.normalize(segment)).length() > max_length) continue;
            this.set_.add(segment);
        }
    }

    boolean contains(String segment) {
        return this.set_.contains(segment);
    }

    public int size() {
        return this.set_.size();
    }
}

