/*
 * Decompiled with CFR 0.152.
 */
package marmot.morph.mapper.latin;

import java.io.IOException;
import java.io.Writer;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import marmot.core.Sequence;
import marmot.core.Tagger;
import marmot.morph.MorphModel;
import marmot.morph.MorphOptions;
import marmot.morph.Sentence;
import marmot.morph.Word;
import marmot.morph.mapper.Node;
import marmot.morph.mapper.SyntaxTree;
import marmot.morph.mapper.SyntaxTreeIterator;
import marmot.morph.mapper.latin.BrandoliniRules;
import marmot.morph.mapper.latin.ItLdtMapper;
import marmot.morph.mapper.latin.ItMorphTag;
import marmot.morph.mapper.latin.LatMorNormalizer;
import marmot.morph.mapper.latin.LatMorReader;
import marmot.morph.mapper.latin.LdtMorphTag;
import marmot.util.Counter;
import marmot.util.FileUtils;

public class ItTreebankConverter {
    Counter<String> amb_counter;
    Map<String, Counter<String>> amb_map;
    LatMorReader latmor_reader_;
    private static final Set<LdtMorphTag.Pos> nominals = new HashSet<LdtMorphTag.Pos>();

    public ItTreebankConverter(String latmore_file, String missing_file, String wrong_file) throws IOException {
        ItMorphTag.VERBOSE = false;
        this.latmor_reader_ = new LatMorReader();
        try {
            this.latmor_reader_.readLatMorFile(latmore_file);
            if (missing_file != null) {
                this.latmor_reader_.readMissingFile(missing_file);
            }
            if (wrong_file != null) {
                this.latmor_reader_.readWrongFile(wrong_file);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.amb_counter = new Counter();
        this.amb_map = new HashMap<String, Counter<String>>();
    }

    public void convert(String in_treebank_file, String out_treebank_file) throws IOException {
        List<SyntaxTree> trees = this.readInitialTrees(in_treebank_file);
        this.replaceUnkownPosTags(trees);
        Calendar c = Calendar.getInstance();
        String date_string = String.format("-%d-%d-%d", c.get(1), c.get(2), c.get(5));
        out_treebank_file = (String)out_treebank_file + date_string + ".conll";
        Writer writer = FileUtils.openFileWriter((String)out_treebank_file);
        for (SyntaxTree tree : trees) {
            tree.write(writer);
            writer.write(10);
        }
        writer.close();
    }

    public Word nodeToWord(Node node, boolean delete_x) {
        String[] feats;
        String form = node.getForm();
        String lemma = node.getLemma();
        Set<LdtMorphTag.Pos> candidates = this.latmor_reader_.getPosCandidates(form, lemma);
        LdtMorphTag tag = (LdtMorphTag)node.getMorphTag();
        LdtMorphTag.Pos pos = tag.pos_;
        form = node.getLemma();
        if (nominals.contains((Object)pos)) {
            feats = new String[nominals.size() + 1];
            int index = 0;
            for (LdtMorphTag.Pos p : nominals) {
                feats[index++] = p.toString();
            }
            feats[index++] = node.getDeprel();
        } else if (pos == LdtMorphTag.Pos.x && !delete_x) {
            candidates.retainAll(nominals);
            if (candidates.isEmpty()) {
                candidates = nominals;
            }
            feats = new String[candidates.size() + 1];
            int index = 0;
            for (LdtMorphTag.Pos p : candidates) {
                feats[index++] = p.toString();
            }
            feats[index++] = node.getDeprel();
        } else {
            form = form.toUpperCase();
            feats = new String[]{form.toUpperCase()};
        }
        return new Word(form, pos.toString(), null, feats, null, null);
    }

    public void replaceUnkownPosTags(List<SyntaxTree> trees) {
        LinkedList<Sequence> sentences = new LinkedList<Sequence>();
        for (SyntaxTree tree : trees) {
            LinkedList<Word> words = new LinkedList<Word>();
            for (Node node : tree.getNodes()) {
                words.add(this.nodeToWord(node, true));
            }
            sentences.add(new Sentence(words));
        }
        MorphOptions opts = new MorphOptions();
        opts.setProperty("shape", "false");
        opts.setProperty("tag-morph", "false");
        opts.setProperty("order", "2");
        opts.setProperty("verbose", "false");
        opts.setProperty("num-iterations", "10");
        Tagger tagger = MorphModel.train(opts, sentences, null);
        this.replaceUnkownPosTagsWithTagger(trees, tagger);
    }

    public void replaceUnkownPosTagsWithTagger(List<SyntaxTree> trees, Tagger tagger) {
        Counter<LdtMorphTag.Pos> counter = new Counter<LdtMorphTag.Pos>();
        for (SyntaxTree tree : trees) {
            LinkedList<Word> words = new LinkedList<Word>();
            boolean contains_unkown = false;
            for (Node node : tree.getNodes()) {
                words.add(this.nodeToWord(node, false));
                if (((LdtMorphTag)node.getMorphTag()).pos_ != LdtMorphTag.Pos.x) continue;
                contains_unkown = true;
            }
            if (!contains_unkown) continue;
            Sentence sentence = new Sentence(words);
            List<List<String>> tags = tagger.tag(sentence);
            assert (tags.size() == tree.getNodes().size());
            for (int i = 0; i < tags.size(); ++i) {
                Node node = tree.getNodes().get(i);
                LdtMorphTag tag = (LdtMorphTag)node.getMorphTag();
                if (tag.pos_ != LdtMorphTag.Pos.x) continue;
                switch (tags.get(i).get(0)) {
                    case "n": {
                        tag.pos_ = LdtMorphTag.Pos.n;
                        break;
                    }
                    case "a": {
                        tag.pos_ = LdtMorphTag.Pos.a;
                        break;
                    }
                    case "m": {
                        tag.pos_ = LdtMorphTag.Pos.m;
                        break;
                    }
                    case "p": {
                        tag.pos_ = LdtMorphTag.Pos.p;
                        break;
                    }
                    default: {
                        System.err.println("Unexpected tag: " + tag);
                    }
                }
                counter.increment(tag.pos_, 1.0);
            }
        }
        System.err.print("Replacement statistics: ");
        System.err.println(counter);
    }

    private List<SyntaxTree> readInitialTrees(String in_treebank_file) {
        LinkedList<SyntaxTree> trees = new LinkedList<SyntaxTree>();
        SyntaxTreeIterator iterator2 = new SyntaxTreeIterator(in_treebank_file, 1, 2, 4, 5, 6, 7, false);
        while (iterator2.hasNext()) {
            SyntaxTree tree = iterator2.next();
            for (Node node : tree.getNodes()) {
                LdtMorphTag tag;
                String fpos;
                String form = LatMorNormalizer.normalize(node.getForm());
                node.setForm(form);
                String lemma = LatMorNormalizer.normalize(node.getLemma());
                int index = lemma.indexOf(94);
                if (index >= 0) {
                    lemma = lemma.substring(0, index);
                }
                node.setLemma(lemma);
                String deprel = node.getDeprel().toLowerCase();
                node.setDeprel(deprel);
                String cpos = fpos = node.getPos();
                if (fpos.length() == 2 && !fpos.equalsIgnoreCase("oq")) {
                    cpos = fpos.substring(1);
                    assert (Character.isDigit(cpos.charAt(0)));
                }
                String feats = node.getFeats();
                String tag_string = String.format("%s %s %s", cpos, fpos, feats);
                if (cpos.equals("Punc")) {
                    tag = new LdtMorphTag();
                    tag.pos_ = LdtMorphTag.Pos.u;
                } else {
                    tag = this.convert(form, lemma, tag_string, deprel);
                }
                node.setMorphTag(tag);
            }
            trees.add(tree);
        }
        System.err.print("Ambiguity stats: ");
        System.err.println(this.amb_counter);
        Counter<String> counter = this.amb_map.get("unk");
        if (counter != null) {
            System.err.println("Unknown forms: " + counter.size());
        }
        return trees;
    }

    public LdtMorphTag convert(String form, String lemma, String tag_string, String deprel) {
        BrandoliniRules rules = new BrandoliniRules();
        ItLdtMapper mapper = new ItLdtMapper();
        ItMorphTag it_tag = (ItMorphTag)ItMorphTag.parseString(tag_string);
        LdtMorphTag ldt_tag = (LdtMorphTag)mapper.convert(it_tag);
        Set<LdtMorphTag.Pos> candidates = rules.getCandidates(form, lemma, deprel, ldt_tag, it_tag);
        if (candidates.isEmpty()) {
            candidates = mapper.getPosCandidates(ldt_tag, it_tag);
        }
        ldt_tag.pos_ = candidates.isEmpty() ? LdtMorphTag.Pos.Undef : (candidates.size() == 1 ? candidates.iterator().next() : this.mergeWithLatMor(form, lemma, candidates, ldt_tag));
        return ldt_tag;
    }

    public LdtMorphTag.Pos mergeWithLatMor(String form, String lemma, Set<LdtMorphTag.Pos> candidates, LdtMorphTag ldt_tag) {
        LdtMorphTag.Pos pos = LdtMorphTag.Pos.Undef;
        Set<LdtMorphTag.Pos> tags = this.latmor_reader_.getPosCandidates(form, lemma);
        if (!tags.isEmpty() && (pos = this.mergeWithLatMor(tags, candidates, ldt_tag, form, false)) != LdtMorphTag.Pos.Undef) {
            return pos;
        }
        Set<String> lemmas = this.latmor_reader_.getLemmas(form);
        if (lemmas != null && lemmas.contains("_")) {
            tags = this.latmor_reader_.getPosCandidates(form, "_");
            pos = this.mergeWithLatMor(tags, candidates, ldt_tag, form, false);
            if (pos != LdtMorphTag.Pos.Undef) {
                return pos;
            }
        } else {
            this.addToCounter("unk", form);
        }
        if (pos == LdtMorphTag.Pos.Undef) {
            pos = this.ambiguous(candidates);
            this.addToCounter(pos.toString(), form);
        }
        return pos;
    }

    private LdtMorphTag.Pos ambiguous(Set<LdtMorphTag.Pos> merged_set) {
        if (merged_set.size() > 1 && (merged_set.contains((Object)LdtMorphTag.Pos.a) || merged_set.contains((Object)LdtMorphTag.Pos.m) || merged_set.contains((Object)LdtMorphTag.Pos.p) || merged_set.contains((Object)LdtMorphTag.Pos.n))) {
            assert (!merged_set.contains((Object)LdtMorphTag.Pos.c) || merged_set.contains((Object)LdtMorphTag.Pos.r));
            return LdtMorphTag.Pos.x;
        }
        return LdtMorphTag.Pos.Undef;
    }

    private LdtMorphTag.Pos mergeWithLatMor(Set<LdtMorphTag.Pos> tags, Set<LdtMorphTag.Pos> candidates, LdtMorphTag ldt_tag, String form, boolean found_lemma) {
        HashSet<LdtMorphTag.Pos> merged_set = new HashSet<LdtMorphTag.Pos>(candidates);
        merged_set.retainAll(tags);
        if (merged_set.size() == 1) {
            return (LdtMorphTag.Pos)((Object)merged_set.iterator().next());
        }
        if (!found_lemma) {
            this.addToAmbCounter(merged_set, form);
        }
        return LdtMorphTag.Pos.Undef;
    }

    private void addToAmbCounter(Set<LdtMorphTag.Pos> merged_set, String form) {
        LinkedList<String> list = new LinkedList<String>();
        for (LdtMorphTag.Pos pos : merged_set) {
            list.add(pos.toString());
        }
        Collections.sort(list);
        if (list.isEmpty()) {
            list.add(".");
        }
        this.addToCounter(((Object)list).toString(), form);
    }

    private void addToCounter(String string, String form) {
        this.amb_counter.increment(string, 1.0);
        Counter forms = this.amb_map.computeIfAbsent(string, k -> new Counter());
        forms.increment(form, 1.0);
    }

    public static void main(String[] args) throws IOException {
        ItTreebankConverter conv = new ItTreebankConverter(args[0], args[1], args[2]);
        conv.convert(args[3], args[4]);
    }

    static {
        nominals.add(LdtMorphTag.Pos.p);
        nominals.add(LdtMorphTag.Pos.n);
        nominals.add(LdtMorphTag.Pos.m);
        nominals.add(LdtMorphTag.Pos.a);
    }
}

