/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.adjunct.InspectionAdjunct;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.WatchManager;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.InstanceOfExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;

public class InstanceOfAdjunct
extends InspectionAdjunct
implements FeedMaker {
    @Override
    public Feed makeItemFeed(WatchManager watchManager, Feed out, XPathContext context) throws XPathException {
        return new InstanceOfFeed(this.getExpression(), out, context);
    }

    private static class InstanceOfFeed
    extends ItemFeed {
        ItemType itemType;
        int count;
        int cardinality;
        boolean matchesSoFar;

        public InstanceOfFeed(Expression exp, Feed result, XPathContext context) {
            super(exp, result, context);
            this.itemType = ((InstanceOfExpression)exp).getRequiredItemType();
            this.cardinality = ((InstanceOfExpression)exp).getRequiredCardinality();
            this.matchesSoFar = true;
        }

        @Override
        public void open(Terminator terminator) throws XPathException {
            super.open(terminator);
            this.count = 0;
            this.matchesSoFar = true;
        }

        @Override
        public void processItem(Item<?> item) throws XPathException {
            if (this.matchesSoFar) {
                if (!this.itemType.matches(item, this.getContext().getConfiguration().getTypeHierarchy())) {
                    this.matchesSoFar = false;
                }
                ++this.count;
                if (this.count == 2 && !Cardinality.allowsMany(this.cardinality)) {
                    this.matchesSoFar = false;
                }
                if (!this.matchesSoFar) {
                    this.getResult().processItem(BooleanValue.FALSE);
                    this.getResult().close();
                    this.getTerminator().terminate();
                }
            }
        }

        @Override
        public void close() throws XPathException {
            if (this.matchesSoFar) {
                if (this.count == 0 && !Cardinality.allowsZero(this.cardinality)) {
                    this.matchesSoFar = false;
                }
                this.getResult().processItem(BooleanValue.get(this.matchesSoFar));
                this.getResult().close();
            }
        }
    }
}

