/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToBooleanCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.OnEmpty;
import com.saxonica.objectweb.asm.Type;
import java.math.BigDecimal;
import net.sf.saxon.expr.CompareToIntegerConstant;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.NumericValue;

public class CompareToIntegerConstantCompiler
extends ToBooleanCompiler {
    @Override
    public void compileToBoolean(CompilerService compiler, Expression expression) throws CannotCompileException {
        boolean isUnknownNumeric;
        Expression exp = ((CompareToIntegerConstant)expression).getBaseExpression();
        int operator = ((CompareToIntegerConstant)expression).getComparisonOperator();
        long comparand = ((CompareToIntegerConstant)expression).getComparand();
        boolean allowsEmpty = Cardinality.allowsZero(expression.getCardinality());
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        CompareToIntegerConstantCompiler.visitAnnotation(compiler, "CompareToIntegerCompiler");
        CompareToIntegerConstantCompiler.visitLineNumber(compiler, ga, expression);
        LabelInfo returnTrue = methodInfo.newLabel("returnTrue");
        LabelInfo returnFalse = methodInfo.newLabel("returnFalse");
        LabelInfo end = methodInfo.newLabel("endCmpToInt");
        TypeHierarchy th = compiler.getConfiguration().getTypeHierarchy();
        ItemType operandType = exp.getItemType();
        boolean isDouble = th.isSubType(operandType, BuiltInAtomicType.DOUBLE);
        boolean isFloat = th.isSubType(operandType, BuiltInAtomicType.FLOAT);
        boolean isInteger = th.isSubType(operandType, BuiltInAtomicType.INTEGER);
        boolean isDecimal = !isInteger && th.isSubType(operandType, BuiltInAtomicType.DECIMAL);
        boolean bl = isUnknownNumeric = !isDouble && !isFloat && !isInteger && !isDecimal;
        if (isInteger && compiler.isInRangeForInt(exp) && Math.abs(comparand) < Integer.MAX_VALUE) {
            compiler.compileToPrimitive(exp, Integer.TYPE, new OnEmpty.UnwindAndJump(returnFalse));
            ga.push((int)comparand);
            ga.ifCmp(Type.INT_TYPE, this.translateOperator(operator), returnTrue.label());
        } else if (isInteger && compiler.isInRangeForLong(exp)) {
            compiler.compileToPrimitive(exp, Long.TYPE, new OnEmpty.UnwindAndJump(returnFalse));
            ga.push(comparand);
            ga.ifCmp(Type.LONG_TYPE, this.translateOperator(operator), returnTrue.label());
        } else {
            compiler.compileToItem(exp);
            ga.checkClass(NumericValue.class);
            int numericVar = methodInfo.allocateLocal(NumericValue.class);
            ga.storeLocal(numericVar);
            if (isUnknownNumeric || isDouble || isFloat) {
                ga.loadLocal(numericVar);
                ga.invokeInstanceMethod(NumericValue.class, "isNaN", new Class[0]);
                ga.ifTrue(operator == 51 ? returnTrue : returnFalse);
            }
            if (isDouble || isFloat) {
                double value = comparand;
                ga.loadLocal(numericVar);
                ga.invokeInstanceMethod(NumericValue.class, "getDoubleValue", new Class[0]);
                ga.push(value);
                ga.ifCmp(Type.getType(Double.TYPE), this.translateOperator(operator), returnTrue.label());
            } else if (isInteger) {
                if (comparand == 0L) {
                    ga.loadLocal(numericVar);
                    ga.invokeInstanceMethod(NumericValue.class, "signum", new Class[0]);
                    ga.ifZCmp(this.translateOperator(operator), returnTrue.label());
                } else {
                    ga.loadLocal(numericVar);
                    ga.push(comparand);
                    ga.invokeInstanceMethod(NumericValue.class, "compareTo", Long.TYPE);
                    ga.ifZCmp(this.translateOperator(operator), returnTrue.label());
                }
            } else if (th.isSubType(operandType, BuiltInAtomicType.DECIMAL)) {
                ga.loadLocal(numericVar);
                ga.invokeInstanceMethod(NumericValue.class, "getDecimalValue", new Class[0]);
                ga.newInstance(BigDecimal.class);
                ga.dup();
                ga.push(comparand);
                ga.invokeConstructor(BigDecimal.class, Long.TYPE);
                ga.invokeInstanceMethod(BigDecimal.class, "compareTo", BigDecimal.class);
                ga.ifZCmp(this.translateOperator(operator), returnTrue.label());
            } else {
                ga.loadLocal(numericVar);
                ga.push(comparand);
                ga.invokeInstanceMethod(NumericValue.class, "compareTo", Long.TYPE);
                ga.ifZCmp(this.translateOperator(operator), returnTrue.label());
            }
            methodInfo.placeLabel(returnFalse);
            methodInfo.releaseLocal(numericVar);
        }
        ga.push(false);
        ga.goTo(end);
        methodInfo.placeLabel(returnTrue);
        ga.push(true);
        methodInfo.placeLabel(end);
    }

    private int translateOperator(int op) {
        switch (op) {
            case 50: {
                return 153;
            }
            case 51: {
                return 154;
            }
            case 52: {
                return 157;
            }
            case 53: {
                return 155;
            }
            case 54: {
                return 156;
            }
            case 55: {
                return 158;
            }
        }
        throw new UnsupportedOperationException("Unknown operator " + op);
    }
}

