/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode.converter;

import com.saxonica.ee.bytecode.ExpressionCompiler;
import com.saxonica.ee.bytecode.converter.ConverterCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.OnEmpty;
import com.saxonica.objectweb.asm.Type;
import java.util.Stack;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Int64Value;

public class BooleanToIntegerCompiler
extends ConverterCompiler {
    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        CastExpression cast = (CastExpression)expression;
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        boolean allowsEmpty = Cardinality.allowsZero(cast.getCardinality());
        ExpressionCompiler.visitAnnotation(compiler, "BooleanToIntegerConverter-Item");
        if (allowsEmpty) {
            LabelInfo empty = methodInfo.newLabel("returnEmpty");
            LabelInfo end = methodInfo.newLabel("end");
            this.compileToPrimitive(compiler, expression, Boolean.TYPE, new OnEmpty.UnwindAndJump(new Stack<Class>(), empty));
            ga.cast(Type.INT_TYPE, Type.LONG_TYPE);
            ga.invokeStaticMethod(Int64Value.class, "makeIntegerValue", Long.TYPE);
            ga.goTo(end);
            methodInfo.placeLabel(empty);
            ga.pushNull();
            methodInfo.placeLabel(end);
        } else {
            this.compileToPrimitive(compiler, expression, Boolean.TYPE, OnEmpty.RETURN_NULL);
            ga.cast(Type.INT_TYPE, Type.LONG_TYPE);
            ga.invokeStaticMethod(Int64Value.class, "makeIntegerValue", Long.TYPE);
        }
    }

    @Override
    public void compileToPrimitive(CompilerService compiler, Expression expression, Class requiredClass, OnEmpty onEmpty) throws CannotCompileException {
        CastExpression cast = (CastExpression)expression;
        Expression base = cast.getBaseExpression();
        boolean allowsEmpty = Cardinality.allowsZero(cast.getCardinality());
        ExpressionCompiler.visitAnnotation(compiler, "BooleanToIntegerConverter-Primitive");
        if (allowsEmpty && !(onEmpty instanceof OnEmpty.UnwindAndJump)) {
            throw new IllegalArgumentException();
        }
        compiler.compileToBoolean(base);
    }
}

