/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.adjunct.StreamingAdjunct;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.watch.WatchManager;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Fold;
import net.sf.saxon.functions.FoldingFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;

public class FoldStreamer
extends StreamingAdjunct
implements FeedMaker {
    @Override
    public FeedMaker getFeedMaker(int arg) throws XPathException {
        return arg == 0 ? this : this.getDefaultFeedMaker(arg);
    }

    @Override
    public Feed makeItemFeed(WatchManager watchManager, Feed out, XPathContext context) throws XPathException {
        SystemFunctionCall call = (SystemFunctionCall)this.getExpression();
        return new FoldFeed(call, out, context);
    }

    private static class FoldFeed
    extends ItemFeed {
        private Fold fold;

        public FoldFeed(SystemFunctionCall expression, Feed result, XPathContext context) throws XPathException {
            super(expression, result, context);
            Sequence[] additionalArgs = SequenceTool.makeSequenceArray(expression.getArity() - 1);
            for (int i = 1; i < expression.getArity(); ++i) {
                additionalArgs[i - 1] = SequenceTool.toLazySequence(expression.getArg(i).iterate(context));
            }
            FoldingFunction ff = (FoldingFunction)expression.getTargetFunction();
            this.fold = ff.getFold(context, additionalArgs);
        }

        @Override
        public void processItem(Item<?> item) throws XPathException {
            if (!this.hasFailed()) {
                try {
                    this.fold.processItem(item);
                }
                catch (XPathException err) {
                    this.dynamicError(err);
                }
                if (this.fold.isFinished()) {
                    this.close();
                    this.getTerminator().terminate();
                }
            }
        }

        @Override
        public void close() throws XPathException {
            if (!this.hasFailed()) {
                Sequence<?> value = this.fold.result();
                Feed out = this.getResult();
                FoldFeed.processItems(value.iterate(), out);
                out.close();
            }
        }
    }
}

