/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.tokenizer;

import java.io.IOException;
import opennlp.tools.cmdline.AbstractCrossValidatorTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.params.CVParams;
import opennlp.tools.cmdline.tokenizer.TokenEvaluationErrorListener;
import opennlp.tools.cmdline.tokenizer.TokenizerTrainerTool;
import opennlp.tools.cmdline.tokenizer.TrainingParams;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.tokenize.TokenSample;
import opennlp.tools.tokenize.TokenizerCrossValidator;
import opennlp.tools.tokenize.TokenizerFactory;
import opennlp.tools.util.eval.FMeasure;
import opennlp.tools.util.model.ModelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TokenizerCrossValidatorTool
extends AbstractCrossValidatorTool<TokenSample, CVToolParams> {
    private static final Logger logger = LoggerFactory.getLogger(TokenizerCrossValidatorTool.class);

    public TokenizerCrossValidatorTool() {
        super(TokenSample.class, CVToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "K-fold cross validator for the learnable tokenizer";
    }

    @Override
    public void run(String format, String[] args2) {
        TokenizerCrossValidator validator;
        super.run(format, args2);
        this.mlParams = CmdLineUtil.loadTrainingParameters(((CVToolParams)this.params).getParams(), false);
        if (this.mlParams == null) {
            this.mlParams = ModelUtil.createDefaultTrainingParameters();
        }
        TokenEvaluationErrorListener listener = null;
        if (((CVToolParams)this.params).getMisclassified().booleanValue()) {
            listener = new TokenEvaluationErrorListener();
        }
        try {
            Dictionary dict = TokenizerTrainerTool.loadDict(((CVToolParams)this.params).getAbbDict());
            TokenizerFactory tokFactory = TokenizerFactory.create(((CVToolParams)this.params).getFactory(), ((CVToolParams)this.params).getLang(), dict, ((CVToolParams)this.params).getAlphaNumOpt(), null);
            validator = new TokenizerCrossValidator(this.mlParams, tokFactory, listener);
            validator.evaluate(this.sampleStream, ((CVToolParams)this.params).getFolds());
        }
        catch (IOException e) {
            throw this.createTerminationIOException(e);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException iOException) {}
        }
        FMeasure result = validator.getFMeasure();
        logger.info(result.toString());
    }

    static interface CVToolParams
    extends CVParams,
    TrainingParams {
    }
}

