/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.adjunct.StreamingAdjunct;
import com.saxonica.ee.stream.adjunct.TransmissionAdjunct;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.om.FleetingNode;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.WatchMaker;
import com.saxonica.ee.stream.watch.WatchManager;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.DocumentOrderIterator;
import net.sf.saxon.expr.sort.DocumentSorter;
import net.sf.saxon.expr.sort.GlobalOrderComparer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.z.IntHashMap;

public class DocumentSorterAdjunct
extends TransmissionAdjunct
implements FeedMaker {
    @Override
    public PostureAndSweep computeStreamability(ContextItemStaticInfoEE contextInfo, List<String> reasons) {
        DocumentSorter exp = (DocumentSorter)this.getExpression();
        Expression base = exp.getBaseExpression();
        PostureAndSweep ps = Streamability.getStreamability(base, contextInfo, reasons);
        if (ps.getSweep() == Sweep.CONSUMING && ps.getPosture() == Posture.CRAWLING) {
            Pattern p = this.toStreamingPattern(this.getConfiguration());
            if (p == null) {
                reasons.add(this.needsSorting());
                reasons.add("The expression " + base + " cannot be used as a scanning expression, because it is not valid as a pattern");
                return PostureAndSweep.ROAMING_AND_FREE_RANGING;
            }
            if (p.isMotionless()) {
                base.setExtraProperty("scanningPattern", p);
                return ps;
            }
            reasons.add(this.needsSorting());
            reasons.add("The expression " + exp.getBaseExpression() + " cannot be used as a scanning expression, because as a pattern, it is not motionless");
            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
        }
        if (ps.getSweep() == Sweep.MOTIONLESS || ps.getPosture() == Posture.GROUNDED || ps.getPosture() == Posture.CLIMBING || ps.getPosture() == Posture.STRIDING || ps.getPosture() == Posture.CRAWLING) {
            return ps;
        }
        if (reasons != null) {
            reasons.add("Expression " + exp.getBaseExpression().toShortString() + " requires sorting nodes into document order");
        }
        return PostureAndSweep.ROAMING_AND_FREE_RANGING;
    }

    private String needsSorting() {
        return "Expression " + ((DocumentSorter)this.getExpression()).getBaseExpression().toShortString() + " requires sorting nodes into document order";
    }

    @Override
    public Pattern toStreamingPattern(Configuration config) {
        return Streamability.toStreamingPattern(((DocumentSorter)this.getExpression()).getBaseExpression(), config);
    }

    @Override
    public WatchMaker getWatchMaker(boolean forGrouping) throws XPathException {
        Expression base = ((DocumentSorter)this.getExpression()).getBaseExpression();
        if (base.getExtraProperty("scanningPattern") != null) {
            return StreamingAdjunct.makeStreamingAdjunct(this.getConfiguration(), base).getWatchMaker(false);
        }
        return null;
    }

    @Override
    public ItemFeed makeItemFeed(WatchManager watchManager, ItemFeed out, XPathContext context) throws XPathException {
        if (Streamability.getPosture(((DocumentSorter)this.getExpression()).getBaseExpression()) == Posture.STRIDING) {
            return new MixedPostureSorter(out, context);
        }
        return new AncestorArrangingFeed(out, context);
    }

    @Override
    public FeedMaker getFeedMaker(int arg) throws XPathException {
        return arg == 0 ? this : super.getFeedMaker(arg);
    }

    private static class MixedPostureSorter
    extends ItemFeed {
        public List<Item> groundedItems = new ArrayList<Item>();

        public MixedPostureSorter(ItemFeed out, XPathContext context) {
            super(out, context);
        }

        @Override
        public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
            return this.getResultFeed().startSelectedParentNode(node, locationId);
        }

        @Override
        public void append(Item item) throws XPathException {
            if (item instanceof FleetingNode) {
                this.getNextOutputter().append(item);
            } else {
                this.groundedItems.add(item);
            }
        }

        @Override
        public void endSelectedParentNode(Location locationId) throws XPathException {
            this.getResultFeed().endSelectedParentNode(locationId);
        }

        @Override
        public void close() throws XPathException {
            ListIterator.Of<Item> grounded = new ListIterator.Of<Item>(this.groundedItems);
            DocumentOrderIterator sorted = new DocumentOrderIterator(grounded, GlobalOrderComparer.getInstance());
            Outputter out = this.getNextOutputter();
            SequenceTool.supply(sorted, out::append);
            super.close();
        }
    }

    private static class AncestorArrangingFeed
    extends ItemFeed {
        public IntHashMap<NodeInfo> mostRecentAtDepth = new IntHashMap();
        public Stack<NodeInfo> stack = new Stack();

        public AncestorArrangingFeed(ItemFeed out, XPathContext context) {
            super(out, context);
        }

        @Override
        public void append(Item item) throws XPathException {
            NodeInfo node = (NodeInfo)item;
            if (!this.stack.isEmpty() && Navigator.isAncestorOrSelf(node, this.stack.peek())) {
                this.stack.push(node);
            } else {
                this.flush();
                this.stack = new Stack();
                this.stack.push(node);
            }
        }

        @Override
        public void close() throws XPathException {
            this.flush();
            super.close();
        }

        private void flush() throws XPathException {
            Outputter out = this.getNextOutputter();
            while (!this.stack.isEmpty()) {
                NodeInfo n = this.stack.pop();
                int depth = this.depthOfNode(n);
                NodeInfo prev = this.mostRecentAtDepth.get(depth);
                if (prev != null && prev == n) continue;
                out.append(n);
                this.mostRecentAtDepth.put(depth, n);
            }
        }

        private int depthOfNode(NodeInfo n) {
            int depth = 0;
            while ((n = n.getParent()) != null) {
                ++depth;
            }
            return depth;
        }
    }
}

