/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ExpressionCompiler;
import com.saxonica.ee.bytecode.ToIteratorCompiler;
import com.saxonica.ee.bytecode.iter.CompiledBlockIterator;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.objectweb.asm.ClassVisitor;
import com.saxonica.objectweb.asm.ClassWriter;
import com.saxonica.objectweb.asm.Label;
import com.saxonica.objectweb.asm.Type;
import com.saxonica.objectweb.asm.commons.Method;
import com.saxonica.objectweb.asm.commons.TableSwitchGenerator;
import java.util.ArrayList;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.value.Cardinality;

public class BlockCompiler
extends ToIteratorCompiler {
    @Override
    public void compileToPush(CompilerService compiler, Expression expression) throws CannotCompileException {
        Operand[] children = ((Block)expression).getOperanda();
        BlockCompiler.visitAnnotation(compiler, "BlockCompiler-Push");
        for (Operand o : children) {
            compiler.compileToPush(o.getChildExpression());
        }
    }

    @Override
    public void compileToIterator(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        Operand[] children = ((Block)expression).getOperanda();
        BlockCompiler.visitAnnotation(compiler, "BlockCompiler-Itr");
        if (children.length == 0) {
            ga.invokeStaticMethod(EmptyIterator.class, "getInstance", new Class[0]);
        } else if (children.length == 1) {
            compiler.compileToIterator(children[0].getChildExpression());
        } else {
            BlockCompiler.visitLineNumber(compiler, ga, expression);
            Class<? extends CompiledBlockIterator> blockIterator = compiler.getCompiledClass(expression);
            if (blockIterator == null) {
                blockIterator = this.generateBlockIterator(compiler, expression);
                compiler.setCompiledClass(expression, blockIterator);
            }
            BlockCompiler.allocateStatic(compiler, blockIterator);
            ga.invokeInstanceMethod(Class.class, "newInstance", new Class[0]);
            int compiledBlockVar = methodInfo.allocateLocal(CompiledBlockIterator.class);
            ga.storeLocal(compiledBlockVar);
            ga.loadLocal(compiledBlockVar);
            ga.checkClass(CompiledBlockIterator.class);
            compiler.generateGetContext();
            ga.invokeInstanceMethod(CompiledBlockIterator.class, "setContext", XPathContext.class);
            ga.loadLocal(compiledBlockVar);
            ga.checkClass(CompiledBlockIterator.class);
        }
    }

    private Class<? extends CompiledBlockIterator> generateBlockIterator(CompilerService compiler, Expression expression) throws CannotCompileException {
        compiler.checkMaxClassesLimit();
        ClassWriter cw = new ClassWriter(compiler.getFlags());
        ClassVisitor cv = cw;
        String className = "gen_CompiledBlockIterator_" + CompilerService.getUniqueNumber();
        cv = compiler.makeAnnotatedTraceClassVisitor(cv, className);
        cv.visitSource(expression.getLocation().getSystemId(), null);
        cv.visit(49, 1, className, null, "com/saxonica/ee/bytecode/iter/CompiledBlockIterator", new String[0]);
        compiler.pushNewClassInfo(className, CompiledBlockIterator.class, cw);
        this.makeInitMethod(cv);
        this.makeNextMethod(compiler, expression, cv);
        cv.visitEnd();
        BlockCompiler.verify(cw, "BlockIterator at line " + expression.getLocation().getLineNumber(), compiler.isDebugByteCode());
        return compiler.makeClass(cw, className);
    }

    private void makeNextMethod(final CompilerService compiler, Expression expression, ClassVisitor cv) throws CannotCompileException {
        final Operand[] children = ((Block)expression).getOperanda();
        Method m = Method.getMethod("net.sf.saxon.om.Item next()");
        BlockCompiler.visitAnnotation(compiler, "BlockCompiler - next");
        final Generator ga = new Generator(1, m, true, cv);
        int contextVar = ga.newLocal(Type.getType(XPathContext.class));
        final int currentVar = ga.newLocal(Item.class);
        compiler.pushNewMethodInfo(ga, false, contextVar);
        BlockCompiler.visitLineNumber(compiler, ga, expression);
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        ga.loadThis();
        ga.getField(Type.getType(CompiledBlockIterator.class), "context", Type.getType(XPathContext.class));
        compiler.initNewMethod(ga, true);
        ga.pushNull();
        ga.storeLocal(currentVar);
        LabelInfo end = methodInfo.newLabel("endBlock");
        final LabelInfo next = methodInfo.newLabel("next");
        LabelInfo nonNullItem = methodInfo.newLabel("nonNullItem");
        LabelInfo nonNullItr = methodInfo.newLabel("nonNullItr");
        final LabelInfo loop = methodInfo.placeNewLabel("loop");
        ga.loadThis();
        ga.getField(Type.getType(CompiledBlockIterator.class), "currentIterator", Type.getType(SequenceIterator.class));
        ga.dup();
        ga.ifNonNull(nonNullItr.label());
        ga.pop();
        ga.goTo(next);
        methodInfo.placeLabel(nonNullItr);
        ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
        ga.dup();
        ga.storeLocal(currentVar);
        ga.ifNonNull(nonNullItem.label());
        ga.loadThis();
        ga.pushNull();
        ga.putField(Type.getType(CompiledBlockIterator.class), "currentIterator", Type.getType(SequenceIterator.class));
        ga.goTo(next);
        methodInfo.placeLabel(nonNullItem);
        ga.goTo(end);
        methodInfo.placeLabel(next);
        final ArrayList errors = new ArrayList();
        TableSwitchGenerator tabSwitch = new TableSwitchGenerator(){

            @Override
            public void generateCase(int key, Label end) {
                ExpressionCompiler.visitAnnotation(compiler, "BlockCompiler - caseStatement");
                if (key == children.length) {
                    ExpressionCompiler.visitAnnotation(compiler, "BlockCompiler - default");
                    ga.pushNull();
                    ga.storeLocal(currentVar);
                    ga.goTo(end);
                } else {
                    ga.loadThis();
                    ga.push(key + 1);
                    ga.putField(Type.getType(CompiledBlockIterator.class), "state", Type.INT_TYPE);
                    if (Cardinality.allowsMany(children[key].getChildExpression().getCardinality())) {
                        try {
                            ExpressionCompiler.visitAnnotation(compiler, "BlockCompiler - caseStatement" + key);
                            compiler.compileToIterator(children[key].getChildExpression());
                        }
                        catch (CannotCompileException e) {
                            errors.add(e);
                            return;
                        }
                        ga.loadThis();
                        ga.swap();
                        ga.putField(Type.getType(CompiledBlockIterator.class), "currentIterator", Type.getType(SequenceIterator.class));
                        ga.goTo(loop);
                    } else {
                        try {
                            ExpressionCompiler.visitAnnotation(compiler, "BlockCompiler - caseStatement-asItem" + key);
                            compiler.compileToItem(children[key].getChildExpression());
                        }
                        catch (CannotCompileException e) {
                            errors.add(e);
                            return;
                        }
                        if (Cardinality.allowsZero(children[key].getChildExpression().getCardinality())) {
                            ga.dup();
                            ga.storeLocal(currentVar);
                            ga.ifNull(next.label());
                        } else {
                            ga.storeLocal(currentVar);
                        }
                        ga.goTo(end);
                    }
                }
            }

            @Override
            public void generateDefault() {
            }
        };
        int[] states = new int[children.length + 1];
        for (int i = 0; i < children.length + 1; ++i) {
            states[i] = i;
        }
        ga.loadThis();
        ga.getField(Type.getType(CompiledBlockIterator.class), "state", Type.INT_TYPE);
        ga.tableSwitch(states, tabSwitch);
        if (!errors.isEmpty()) {
            throw (CannotCompileException)errors.get(0);
        }
        methodInfo.placeLabel(end);
        ga.loadLocal(currentVar);
        ga.returnValue();
        try {
            ga.endMethod();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("*** end method failed");
        }
        compiler.popCurrentMethodInfo();
    }

    private void makeInitMethod(ClassVisitor cv) {
        Method m = Method.getMethod("void <init> ()");
        Generator ga = new Generator(1, m, false, cv);
        ga.loadThis();
        ga.invokeConstructor(Type.getType(CompiledBlockIterator.class), m);
        ga.returnValue();
        ga.endMethod();
    }
}

