/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToItemCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.OnEmpty;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.functions.Substring;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class SubstringCompiler
extends ToItemCompiler {
    @Override
    public void compileToPrimitive(CompilerService compiler, Expression expression, Class requiredClass, OnEmpty onEmpty) throws CannotCompileException {
        SystemFunctionCall fnc = (SystemFunctionCall)expression;
        Substring fn = (Substring)fnc.getTargetFunction();
        int numArgs = fn.getArity();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        SubstringCompiler.visitAnnotation(compiler, "Substring-str");
        LabelInfo substringReturn = methodInfo.newLabel("substringReturn");
        compiler.compileToItem(fnc.getArg(0));
        this.returnZeroLengthStringIfNull(fnc.getArg(0), ga, methodInfo, substringReturn, 0);
        ga.checkClass(StringValue.class);
        if (numArgs == 2) {
            compiler.compileToItem(fnc.getArg(1));
            ga.checkClass(NumericValue.class);
            ga.invokeStaticMethod(Substring.class, "substring", StringValue.class, NumericValue.class);
        } else {
            compiler.compileToItem(fnc.getArg(1));
            ga.checkClass(NumericValue.class);
            compiler.compileToItem(fnc.getArg(2));
            ga.checkClass(NumericValue.class);
            ga.invokeStaticMethod(Substring.class, "substring", StringValue.class, NumericValue.class, NumericValue.class);
        }
        methodInfo.placeLabel(substringReturn);
        if (requiredClass == String.class) {
            ga.invokeInstanceMethod(Object.class, "toString", new Class[0]);
        }
    }

    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        SystemFunctionCall fnc = (SystemFunctionCall)expression;
        Substring fn = (Substring)fnc.getTargetFunction();
        int numArgs = fn.getArity();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        SubstringCompiler.visitAnnotation(compiler, "Substring-str");
        LabelInfo substringReturn = methodInfo.newLabel("substringReturn");
        compiler.compileToItem(fnc.getArg(0));
        if (Cardinality.allowsZero(fnc.getArg(0).getCardinality())) {
            LabelInfo stringArgNonNull = methodInfo.newLabel("stringArgNonNull");
            ga.dup();
            ga.ifNonNull(stringArgNonNull.label());
            ga.pop();
            SubstringCompiler.allocateStatic(compiler, StringValue.EMPTY_STRING);
            ga.goTo(substringReturn);
            methodInfo.placeLabel(stringArgNonNull);
        }
        ga.checkClass(StringValue.class);
        if (numArgs == 2) {
            compiler.compileToItem(fnc.getArg(1));
            ga.checkClass(NumericValue.class);
            ga.invokeStaticMethod(Substring.class, "substring", StringValue.class, NumericValue.class);
            ga.invokeStaticMethod(StringValue.class, "makeStringValue", CharSequence.class);
        } else {
            compiler.compileToItem(fnc.getArg(1));
            ga.checkClass(NumericValue.class);
            compiler.compileToItem(fnc.getArg(2));
            ga.checkClass(NumericValue.class);
            ga.invokeStaticMethod(Substring.class, "substring", StringValue.class, NumericValue.class, NumericValue.class);
            ga.invokeStaticMethod(StringValue.class, "makeStringValue", CharSequence.class);
        }
        methodInfo.placeLabel(substringReturn);
    }
}

