/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.adjunct.TransmissionAdjunct;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.WatchManager;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.TryCatch;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;

public class TryCatchAdjunct
extends TransmissionAdjunct
implements FeedMaker {
    @Override
    public Feed makeItemFeed(WatchManager watchManager, Feed out, XPathContext context) throws XPathException {
        return new TryCatchFeed(this.getExpression(), out, context);
    }

    public static class TryCatchFeed
    extends ItemFeed {
        private SequenceOutputter collector;
        private boolean done = false;
        private boolean open = false;

        public TryCatchFeed(Expression exp, Feed out, XPathContext context) {
            super(exp, out, context);
        }

        @Override
        public void open(Terminator terminator) throws XPathException {
            super.open(terminator);
            this.collector = new SequenceOutputter(this.getPipelineConfiguration());
            this.open = true;
        }

        @Override
        public SequenceReceiver getReceiver() {
            return this.collector;
        }

        @Override
        public void processItem(Item<?> item) throws XPathException {
            this.collector.append(item);
        }

        @Override
        public void close() throws XPathException {
            this.collector.close();
            for (Item<?> i : this.collector.getList()) {
                this.getResult().processItem(i);
            }
            super.close();
        }

        @Override
        public void dynamicError(XPathException err) throws XPathException {
            if (err.isGlobalError()) {
                err.setIsGlobalError(false);
            } else {
                if (this.done) {
                    return;
                }
                if (!this.open) {
                    this.open(new Terminator());
                }
                this.done = true;
                StructuredQName code = err.getErrorCodeQName();
                for (TryCatch.CatchClause clause : ((TryCatch)this.getExpression()).getCatchClauses()) {
                    if (code == null) {
                        code = new StructuredQName("saxon", "http://saxon.sf.net/", "XXXX9999");
                    }
                    if (!clause.nameTest.matches(code)) continue;
                    Expression caught = clause.catchOp.getChildExpression();
                    XPathContextMajor c2 = this.getContext().newContext();
                    c2.setCurrentException(err);
                    SequenceIterator<?> iter = caught.iterate(c2);
                    TryCatchFeed.processItems(iter, this.getResult());
                    this.getResult().close();
                    return;
                }
            }
            err.setHasBeenReported(false);
            throw err;
        }
    }
}

