/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.utils;

import java.io.IOException;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;

public class DelayFilter
extends BaseFilter {
    private final long readTimeoutMillis;
    private final long writeTimeoutMillis;

    public DelayFilter(long readTimeoutMillis, long writeTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
        this.writeTimeoutMillis = writeTimeoutMillis;
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        try {
            Thread.sleep(this.readTimeoutMillis);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        try {
            Thread.sleep(this.writeTimeoutMillis);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ctx.getInvokeAction();
    }
}

