/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query.spans;

import de.ids_mannheim.korap.query.SpanDistanceQuery;
import de.ids_mannheim.korap.query.spans.CandidateSpan;
import de.ids_mannheim.korap.query.spans.OrderedDistanceSpans;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.Bits;

public class ElementDistanceSpans
extends OrderedDistanceSpans {
    private Spans elements;
    private boolean hasMoreElements;
    private int elementPosition;
    private int secondSpanPostion;

    public ElementDistanceSpans(SpanDistanceQuery query, LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        super(query, context, acceptDocs, termContexts);
        this.elements = query.getElementQuery().getSpans(context, acceptDocs, termContexts);
        this.hasMoreElements = this.elements.next();
        this.hasMoreSpans = this.hasMoreFirstSpans && this.hasMoreElements;
        this.elementPosition = 0;
    }

    @Override
    protected boolean findMatch() throws IOException {
        CandidateSpan candidateSpan = (CandidateSpan)this.candidateList.get(this.candidateListIndex);
        int actualDistance = this.secondSpanPostion - candidateSpan.getPosition();
        if (this.minDistance == 0 && actualDistance == 0) {
            this.setMatchProperties(candidateSpan, true);
            return true;
        }
        if (this.minDistance <= actualDistance && actualDistance <= this.maxDistance) {
            this.setMatchProperties(candidateSpan, false);
            return true;
        }
        return false;
    }

    @Override
    protected void setCandidateList() throws IOException {
        if (this.hasMoreSpans && this.hasMoreElements && (this.hasMoreFirstSpans || !this.candidateList.isEmpty())) {
            if (this.candidateListDocNum == this.elements.doc() && this.candidateListDocNum == this.secondSpans.doc()) {
                this.candidateListIndex = -1;
                this.addNewCandidates();
            } else {
                this.candidateList.clear();
                if (this.hasMoreFirstSpans && this.findSameDoc(this.firstSpans, this.secondSpans, this.elements)) {
                    this.candidateListDocNum = this.firstSpans.doc();
                    this.elementPosition = 0;
                    this.candidateListIndex = -1;
                    this.addNewCandidates();
                }
            }
        } else {
            this.candidateList.clear();
        }
    }

    private void addNewCandidates() throws IOException {
        while (this.hasMoreFirstSpans && this.firstSpans.doc() == this.candidateListDocNum && this.firstSpans.start() < this.secondSpans.end()) {
            if (this.advanceElementTo(this.firstSpans)) {
                this.candidateList.add(new CandidateSpan(this.firstSpans, this.elementPosition));
                this.filterCandidateList(this.elementPosition);
            }
            this.hasMoreFirstSpans = this.firstSpans.next();
        }
    }

    private boolean advanceElementTo(Spans span) throws IOException {
        while (this.hasMoreElements && this.elements.doc() == this.candidateListDocNum && this.elements.start() < span.end()) {
            if (span.start() >= this.elements.start() && span.end() <= this.elements.end()) {
                return true;
            }
            this.hasMoreElements = this.elements.next();
            ++this.elementPosition;
        }
        return false;
    }

    private void filterCandidateList(int position) {
        CandidateSpan cs;
        Iterator i = this.candidateList.iterator();
        while (i.hasNext() && (cs = (CandidateSpan)i.next()).getPosition() != position && cs.getPosition() + this.maxDistance < position) {
            i.remove();
        }
    }

    @Override
    protected boolean isSecondSpanValid() throws IOException {
        if (this.advanceElementTo(this.secondSpans)) {
            this.secondSpanPostion = this.elementPosition;
            this.filterCandidateList(this.secondSpanPostion);
            return true;
        }
        return false;
    }

    @Override
    public boolean skipTo(int target) throws IOException {
        if (this.hasMoreSpans && this.secondSpans.doc() < target && !this.secondSpans.skipTo(target)) {
            this.candidateList.clear();
            return false;
        }
        this.setCandidateList();
        while (this.hasMoreSpans && !this.isSecondSpanValid()) {
            this.hasMoreSpans = this.secondSpans.next();
            this.setCandidateList();
        }
        this.matchPayload.clear();
        this.isStartEnumeration = false;
        return this.advance();
    }

    @Override
    public long cost() {
        if (!this.candidateList.isEmpty()) {
            CandidateSpan candidateSpan = (CandidateSpan)this.candidateList.get(this.candidateListIndex);
            return this.elements.cost() + candidateSpan.getCost() + this.secondSpans.cost();
        }
        return this.elements.cost() + this.secondSpans.cost();
    }
}

