/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.StreamingSequenceWriter;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.ItemFeed;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.ApplyTemplates;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.instruct.TemplateRule;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.rules.Rule;
import net.sf.saxon.tree.iter.ManualIterator;

public class ApplyTemplatesFeed
extends ItemFeed {
    XPathContext localContext;
    ManualIterator manual;
    Component.M targetMode;

    public ApplyTemplatesFeed(ApplyTemplates expr, Feed result, XPathContext context) {
        super(expr, result, context);
        this.localContext = context.newMinorContext();
        this.manual = new ManualIterator();
        this.localContext.setCurrentIterator(this.manual);
        this.targetMode = expr.getTargetMode(context);
    }

    @Override
    public void processItem(Item<?> item) throws XPathException {
        this.manual.setContextItem(item);
        this.manual.incrementPosition();
        ParameterSet actualParams = Instruction.assembleParams(this.localContext, ((ApplyTemplates)this.getExpression()).getActualParams());
        ParameterSet tunnelParams = Instruction.assembleTunnelParams(this.localContext, ((ApplyTemplates)this.getExpression()).getTunnelParams());
        XPathContextMajor c2 = this.localContext.newContext();
        c2.setCurrentIterator(this.manual);
        c2.setCurrentMode(this.targetMode);
        c2.setCurrentComponent(this.targetMode);
        c2.setLocalParameters(actualParams);
        c2.setTunnelParameters(tunnelParams);
        c2.setCurrentMergeGroupIterator(null);
        StreamingSequenceWriter writer = new StreamingSequenceWriter(this.getPipelineConfiguration(), this.getResult());
        c2.setReceiver(writer);
        Mode mode = this.targetMode.getActor();
        Rule rule = mode.getRule(item, c2);
        if (rule == null) {
            mode.getBuiltInRuleSet().process(item, actualParams, tunnelParams, c2, ExplicitLocation.UNKNOWN_LOCATION);
        } else {
            TemplateRule template = (TemplateRule)rule.getAction();
            template.initialize();
            c2.openStackFrame(template.getStackFrameMap());
            c2.setCurrentTemplateRule(rule);
            template.apply(c2);
        }
    }
}

