/*
 * Decompiled with CFR 0.152.
 */
package marmot.morph.mapper.german;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import marmot.morph.mapper.Node;
import marmot.morph.mapper.SyntaxTree;
import marmot.morph.mapper.SyntaxTreeIterator;
import marmot.morph.mapper.german.Matcher;
import marmot.morph.mapper.german.SttsTag;
import marmot.util.Counter;
import marmot.util.FileUtils;
import marmot.util.LineIterator;

public class SmorReader {
    public static void main(String[] args) throws IOException {
        SmorReader reader = new SmorReader();
        Map<String, Set<SttsTag>> dict = reader.readFile(args[0]);
        Map<String, Set<SttsTag>> pos_dict = reader.readPosFile(args[1]);
        for (int i = 1; i < args.length; ++i) {
            System.err.println(args[i]);
            reader.test(dict, pos_dict, args[i]);
        }
    }

    private void test(Map<String, Set<SttsTag>> dict, Map<String, Set<SttsTag>> pos_dict, String string) throws IOException {
        Writer writer = FileUtils.openFileWriter(string + ".lattice");
        SyntaxTreeIterator iterator2 = new SyntaxTreeIterator(string, 1, 2, 4, 6, 8, 10, false);
        int pos_candidates = 0;
        int pos_correct = 0;
        int correct = 0;
        int total = 0;
        int candidates = 0;
        int covered = 0;
        Counter candidate_counter = new Counter();
        Counter<String> total_counter = new Counter<String>();
        while (iterator2.hasNext()) {
            SyntaxTree tree = iterator2.next();
            for (Node node : tree.getNodes()) {
                Set<SttsTag> form_set;
                String pos = node.getPos();
                Set<SttsTag> pos_set = pos_dict.get(pos);
                if (this.check(node.getFeats(), pos_set)) {
                    ++pos_correct;
                }
                pos_candidates += pos_set.size();
                if (pos_set.size() > 1 && (form_set = dict.get(this.normalize(node.getForm(), pos))) != null) {
                    ++covered;
                    Set<SttsTag> set = SmorReader.mergeSets(pos_set, form_set);
                    if (!set.isEmpty()) {
                        pos_set = set;
                    }
                }
                if (this.check(node.getFeats(), pos_set)) {
                    ++correct;
                }
                candidates += pos_set.size();
                ++total;
                writer.write(node.getForm());
                if (pos_set.size() < 5) {
                    for (SttsTag tag : pos_set) {
                        writer.write(32);
                        writer.write(tag.feat_string_);
                    }
                } else {
                    writer.write(32);
                    writer.write(42);
                }
                writer.write(10);
            }
            writer.write(10);
        }
        System.err.println("pos correct: " + (double)pos_correct * 100.0 / (double)total);
        System.err.println("pos candidates: " + (double)pos_candidates / (double)total);
        System.err.println("correct: " + (double)correct * 100.0 / (double)total);
        System.err.println("candidates: " + (double)candidates / (double)total);
        System.err.println("coverage: " + (double)covered / (double)total);
        for (Map.Entry entry : candidate_counter.entrySet()) {
            System.err.println((String)entry.getKey() + ":" + entry.getValue() / total_counter.count((String)entry.getKey()));
        }
        writer.close();
    }

    private String normalize(String form, String pos) {
        if (pos.equals("NE")) {
            return form;
        }
        StringBuilder sb = new StringBuilder(form.toLowerCase());
        if (pos.equals("NN")) {
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        }
        return sb.toString();
    }

    boolean check(String tag_string, Set<SttsTag> set) {
        for (SttsTag tag : set) {
            if (!tag.feat_string_.equals(tag_string)) continue;
            return true;
        }
        return false;
    }

    private static Set<SttsTag> mergeSets(Set<SttsTag> pos_set, Set<SttsTag> form_set) {
        HashSet<SttsTag> set = new HashSet<SttsTag>();
        block0: for (SttsTag tag : pos_set) {
            for (SttsTag form_tag : form_set) {
                if (!SmorReader.match(tag, form_tag)) continue;
                set.add(tag);
                continue block0;
            }
        }
        return set;
    }

    static boolean match(SttsTag tag, SttsTag form_tag) {
        Matcher m = new Matcher();
        m.add(tag.case_.toString(), form_tag.case_.toString());
        m.add(tag.gender_.toString(), form_tag.gender_.toString());
        m.add(tag.number_.toString(), form_tag.number_.toString());
        m.add(tag.person_.toString(), form_tag.person_.toString());
        m.add(tag.tense_.toString(), form_tag.tense_.toString());
        m.add(tag.mood_.toString(), form_tag.mood_.toString());
        m.add(tag.degree_.toString(), form_tag.degree_.toString());
        return m.matches();
    }

    private Map<String, Set<SttsTag>> readPosFile(String string) {
        HashMap<String, Set<SttsTag>> map2 = new HashMap<String, Set<SttsTag>>();
        SyntaxTreeIterator iterator2 = new SyntaxTreeIterator(string, 1, 2, 4, 6, 8, 10, false);
        while (iterator2.hasNext()) {
            SyntaxTree tree = iterator2.next();
            for (Node node : tree.getNodes()) {
                Set set = map2.computeIfAbsent(node.getPos(), k -> new HashSet());
                set.add(this.parseSeekerTag(node.getFeats()));
            }
        }
        return map2;
    }

    private SttsTag parseSeekerTag(String feats) {
        String[] features;
        SttsTag tag = new SttsTag();
        for (String feature : features = feats.split("\\|")) {
            if (feature.isEmpty()) continue;
            this.setSeekerFeature(tag, feature);
        }
        tag.setFeatString(feats);
        return tag;
    }

    private void setSeekerFeature(SttsTag tag, String feature) {
        if (feature.equals("_")) {
            return;
        }
        String[] key_value = feature.toLowerCase().split("=");
        String key = key_value[0];
        String value = key_value[1];
        switch (key) {
            case "case": {
                if (value.equals("*")) {
                    tag.case_ = SttsTag.Case.amb;
                    break;
                }
                tag.case_ = SttsTag.Case.valueOf(value);
                break;
            }
            case "number": {
                if (value.equals("*")) {
                    tag.number_ = SttsTag.Number.amb;
                    break;
                }
                tag.number_ = SttsTag.Number.valueOf(value);
                break;
            }
            case "gender": {
                if (value.equals("*")) {
                    tag.gender_ = SttsTag.Gender.amb;
                    break;
                }
                tag.gender_ = SttsTag.Gender.valueOf(value);
                break;
            }
            case "person": {
                switch (value) {
                    case "1": {
                        tag.person_ = SttsTag.Person.fst;
                        break;
                    }
                    case "2": {
                        tag.person_ = SttsTag.Person.snd;
                        break;
                    }
                    case "3": {
                        tag.person_ = SttsTag.Person.thd;
                    }
                }
                break;
            }
            case "tense": {
                tag.tense_ = SttsTag.Tense.valueOf(value);
                break;
            }
            case "mood": {
                tag.mood_ = SttsTag.Mood.valueOf(value);
                break;
            }
            case "degree": {
                if (value.equals("*")) {
                    tag.degree_ = SttsTag.Degree.amb;
                    break;
                }
                tag.degree_ = SttsTag.Degree.valueOf(value);
                break;
            }
            default: {
                throw new RuntimeException("Unknown key: " + key);
            }
        }
    }

    public Map<String, Set<SttsTag>> readFile(String filename) {
        HashMap<String, Set<SttsTag>> dict = new HashMap<String, Set<SttsTag>>();
        LineIterator iterator2 = new LineIterator(filename);
        while (iterator2.hasNext()) {
            Object line = iterator2.next();
            if (line.isEmpty()) continue;
            String form = (String)line.get(0);
            Set readings = dict.computeIfAbsent(form, k -> new HashSet());
            SttsTag tag = this.parseMorphTagString((String)line.get(2), (String)line.get(3));
            readings.add(tag);
        }
        return dict;
    }

    public SttsTag parseMorphTagString(String pos, String morph_tag_string) {
        String[] features;
        SttsTag tag = new SttsTag();
        for (String feature : features = morph_tag_string.split("[<>]")) {
            if (feature.isEmpty()) continue;
            SmorReader.setFeature(tag, feature);
        }
        return tag;
    }

    public static void setFeature(SttsTag tag, String feature) {
        switch (feature = feature.toLowerCase()) {
            case "acc": {
                tag.case_ = SttsTag.Case.acc;
                break;
            }
            case "dat": {
                tag.case_ = SttsTag.Case.dat;
                break;
            }
            case "gen": {
                tag.case_ = SttsTag.Case.gen;
                break;
            }
            case "nom": {
                tag.case_ = SttsTag.Case.nom;
                break;
            }
            case "fem": {
                tag.gender_ = SttsTag.Gender.fem;
                break;
            }
            case "masc": {
                tag.gender_ = SttsTag.Gender.masc;
                break;
            }
            case "neut": {
                tag.gender_ = SttsTag.Gender.neut;
                break;
            }
            case "sg": {
                tag.number_ = SttsTag.Number.sg;
                break;
            }
            case "pl": {
                tag.number_ = SttsTag.Number.pl;
                break;
            }
            case "pos": {
                tag.degree_ = SttsTag.Degree.pos;
                break;
            }
            case "comp": {
                tag.degree_ = SttsTag.Degree.comp;
                break;
            }
            case "sup": {
                tag.degree_ = SttsTag.Degree.sup;
                break;
            }
            case "1": {
                tag.person_ = SttsTag.Person.fst;
                break;
            }
            case "2": {
                tag.person_ = SttsTag.Person.snd;
                break;
            }
            case "3": {
                tag.person_ = SttsTag.Person.thd;
                break;
            }
            case "pres": {
                tag.tense_ = SttsTag.Tense.pres;
                break;
            }
            case "past": {
                tag.tense_ = SttsTag.Tense.past;
                break;
            }
            case "ind": {
                tag.mood_ = SttsTag.Mood.ind;
                break;
            }
            case "subj": {
                tag.mood_ = SttsTag.Mood.subj;
                break;
            }
            case "_": 
            case "pro": 
            case "nogend": 
            case "wk": 
            case "st": 
            case "old": 
            case "invar": 
            case "simp": 
            case "adj": 
            case "def": 
            case "pers": 
            case "refl": 
            case "indef": 
            case "rec": 
            case "neg": 
            case "comma": 
            case "norm": 
            case "left": 
            case "right": 
            case "adv": 
            case "pred": 
            case "inf": 
            case "ppast": 
            case "coord": 
            case "ppres": 
            case "imp": 
            case "zu": 
            case "compar": 
            case "sub": 
            case "ans": 
            case "attr": 
            case "subst": {
                break;
            }
            default: {
                throw new RuntimeException("Unknown feature: " + feature);
            }
        }
    }
}

