/*
 * Decompiled with CFR 0.152.
 */
package marmot.test.tokenizer.opennlp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import marmot.tokenize.openlp.OpenNlpConverter;
import marmot.tokenize.preprocess.Pair;
import marmot.tokenize.rules.RuleProvider;
import marmot.util.FileUtils;
import org.junit.Assert;
import org.junit.Test;

public class OpenNlpConverterTest {
    private OpenNlpConverter es_converter_;
    private Writer writer_;
    private BufferedReader reader_;
    private File tmp_;

    private String getResourceFile(String name) {
        String source = "src" + File.separatorChar;
        Package pack = this.getClass().getPackage();
        String path = pack.getName().replace('.', File.separatorChar) + File.separatorChar;
        return String.format("%s%s%s", source, path, name);
    }

    public OpenNlpConverterTest() {
        RuleProvider es_provider = RuleProvider.createRuleProvider("es");
        this.es_converter_ = new OpenNlpConverter(es_provider);
        this.tmp_ = new File(this.getResourceFile("tmp.txt"));
    }

    @Test
    public void testConvert() throws IOException {
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        String dummy = "";
        this.writer_ = FileUtils.openFileWriter(this.tmp_.getAbsolutePath());
        pairs.add(new Pair("Eso , es : un ! ejemplo .", "Eso, es: un! ejemplo."));
        this.es_converter_.convert(pairs, this.writer_, 0);
        this.writer_.close();
        this.reader_ = new BufferedReader(new FileReader(this.tmp_));
        this.reader_ = new BufferedReader(new FileReader(this.tmp_));
        String prediction_1 = "";
        while ((dummy = this.reader_.readLine()) != null) {
            prediction_1 = dummy;
        }
        this.reader_.close();
        String result_1 = "Eso<SPLIT>, es<SPLIT>: un<SPLIT>! ejemplo<SPLIT>.";
        Assert.assertEquals((Object)prediction_1, (Object)result_1);
        this.writer_ = FileUtils.openFileWriter(this.tmp_.getAbsolutePath());
        pairs.add(new Pair("Demonstration , de el poder de : \" una regla sobre todo \" !", "Demonstration, del poder de: \"una regla sobre todo\"!"));
        this.es_converter_.convert(pairs, this.writer_, 0);
        this.writer_.close();
        this.reader_ = new BufferedReader(new FileReader(this.tmp_));
        String prediction_2 = "";
        while ((dummy = this.reader_.readLine()) != null) {
            prediction_2 = dummy;
        }
        this.reader_.close();
        String result_2 = "Demonstration<SPLIT>, de el poder de<SPLIT>: \"<SPLIT>una regla sobre todo<SPLIT>\"<SPLIT>!";
        Assert.assertEquals((Object)prediction_2, (Object)result_2);
        this.writer_ = FileUtils.openFileWriter(this.tmp_.getAbsolutePath());
        pairs.add(new Pair("Es en este contexto , tal como lo se\u00f1ala el libro de profeta Daniel , cuando el rey Nabucodonosor tiene el sue\u00f1o de esta colosal estatua .", "Es en este contexto, tal como lo se\u00f1ala el libro de profeta Daniel, cuando el rey Nabucodonosor tiene el sue\u00f1o de esta colosal estatua."));
        this.es_converter_.convert(pairs, this.writer_, 0);
        this.writer_.close();
        this.reader_ = new BufferedReader(new FileReader(this.tmp_));
        String prediction_3 = "";
        while ((dummy = this.reader_.readLine()) != null) {
            prediction_3 = dummy;
        }
        this.reader_.close();
        String result_3 = "Es en este contexto<SPLIT>, tal como lo se\u00f1ala el libro de profeta Daniel<SPLIT>, cuando el rey Nabucodonosor tiene el sue\u00f1o de esta colosal estatua<SPLIT>.";
        Assert.assertEquals((Object)prediction_3, (Object)result_3);
    }
}

