/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Query;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.URIQueryParameters;
import net.sf.saxon.functions.UnparsedTextFunction;
import net.sf.saxon.functions.registry.BuiltInFunctionSet;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LazySequence;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.serialize.SerializationParamsHandler;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.serialize.charcode.XMLCharacterData;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XmlProcessingException;
import net.sf.saxon.transpile.CSharp;
import net.sf.saxon.tree.iter.TextLinesIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.z.IntPredicateLambda;

public class EXPathFileFunctionSet
extends BuiltInFunctionSet {
    private static final EXPathFileFunctionSet THE_INSTANCE = new EXPathFileFunctionSet();
    public static final BigDecimalValue VERSION = new BigDecimalValue(new BigDecimal("1.0"));
    public static final NamespaceUri NAMESPACE;
    public static final String PREFIX = "file";
    public static final NamespaceUri ERROR_NAMESPACE;
    public static final String ERROR_PREFIX = "file";
    private static final String ERROR_PATH_NOT_EXIST = "not-found";
    private static final String ERROR_PATH_EXISTS = "exists";
    private static final String ERROR_PATH_NOT_DIRECTORY = "no-dir";
    private static final String ERROR_PATH_IS_DIRECTORY = "is-dir";
    private static final String ERROR_UNKNOWN_ENCODING = "unknown-encoding";
    public static final String ERROR_INDEX_OUT_OF_BOUNDS = "out-of-range";
    public static final String ERROR_IO = "io-error";
    public static final String NEWLINE;

    public static EXPathFileFunctionSet getInstance() {
        return THE_INSTANCE;
    }

    private EXPathFileFunctionSet() {
        this.init();
    }

    private void init() {
        this.register("append", 2, e -> e.populate(FileAppend::new, AnyItemType.getInstance(), 57344, 8704).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, AnyItemType.getInstance(), 57344, null));
        this.register("append", 3, e -> e.populate(FileAppend::new, AnyItemType.getInstance(), 57344, 8704).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, AnyItemType.getInstance(), 57344, null).arg(2, NodeKindTest.ELEMENT, 16384, null));
        this.register("append-binary", 2, e -> e.populate(FileAppendBinary::new, AnyItemType.getInstance(), 57344, 8704).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, BuiltInAtomicType.BASE64_BINARY, 16384, null));
        this.register("append-text", 2, e -> e.populate(FileAppendText::new, AnyItemType.getInstance(), 57344, 8704).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, BuiltInAtomicType.STRING, 16384, null));
        this.register("append-text", 3, e -> e.populate(FileAppendText::new, AnyItemType.getInstance(), 57344, 8704).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, BuiltInAtomicType.STRING, 16384, null).arg(2, BuiltInAtomicType.STRING, 16384, null));
        this.register("append-text-lines", 2, e -> e.populate(FileAppendTextLines::new, AnyItemType.getInstance(), 57344, 8704).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, BuiltInAtomicType.STRING, 57344, null));
        this.register("append-text-lines", 3, e -> e.populate(FileAppendTextLines::new, AnyItemType.getInstance(), 57344, 8704).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, BuiltInAtomicType.STRING, 57344, null).arg(2, BuiltInAtomicType.STRING, 16384, null));
        this.register("base-dir", 0, e -> e.populate(FileBaseDir::new, AnyItemType.getInstance(), 24576, 0));
        this.register("children", 1, e -> e.populate(FileChildren::new, BuiltInAtomicType.STRING, 57344, 512).arg(0, BuiltInAtomicType.STRING, 16384, null));
        this.register("copy", 2, e -> e.populate(FileCopy::new, AnyItemType.getInstance(), 57344, 8704).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, BuiltInAtomicType.STRING, 16384, null));
        this.register("create-dir", 1, e -> e.populate(FileCreateDir::new, AnyItemType.getInstance(), 57344, 8704).arg(0, BuiltInAtomicType.STRING, 16384, null));
        this.register("create-temp-dir", 2, e -> e.populate(FileCreateTempDir::new, AnyItemType.getInstance(), 57344, 8704).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, BuiltInAtomicType.STRING, 16384, null));
        this.register("create-temp-dir", 3, e -> e.populate(FileCreateTempDir::new, AnyItemType.getInstance(), 57344, 8704).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, BuiltInAtomicType.STRING, 16384, null).arg(2, BuiltInAtomicType.STRING, 16384, null));
        this.register("create-temp-file", 2, e -> e.populate(FileCreateTempFile::new, AnyItemType.getInstance(), 57344, 8704).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, BuiltInAtomicType.STRING, 16384, null));
        this.register("create-temp-file", 3, e -> e.populate(FileCreateTempFile::new, AnyItemType.getInstance(), 57344, 8704).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, BuiltInAtomicType.STRING, 16384, null).arg(2, BuiltInAtomicType.STRING, 16384, null));
        this.register("current-dir", 0, e -> e.populate(FileCurrentDir::new, BuiltInAtomicType.STRING, 16384, 0));
        this.register("delete", 1, e -> e.populate(FileDelete::new, AnyItemType.getInstance(), 57344, 8704).arg(0, BuiltInAtomicType.STRING, 16384, null));
        this.register("delete", 2, e -> e.populate(FileDelete::new, AnyItemType.getInstance(), 57344, 8704).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, BuiltInAtomicType.BOOLEAN, 16384, null));
        this.register("dir-separator", 0, e -> e.populate(FileDirSeparator::new, BuiltInAtomicType.STRING, 16384, 0));
        this.register(ERROR_PATH_EXISTS, 1, e -> e.populate(FileExists::new, BuiltInAtomicType.BOOLEAN, 16384, 512).arg(0, BuiltInAtomicType.STRING, 16384, null));
        this.register(ERROR_PATH_IS_DIRECTORY, 1, e -> e.populate(FileIsDir::new, BuiltInAtomicType.BOOLEAN, 16384, 512).arg(0, BuiltInAtomicType.STRING, 16384, null));
        this.register("is-file", 1, e -> e.populate(FileIsFile::new, BuiltInAtomicType.BOOLEAN, 16384, 512).arg(0, BuiltInAtomicType.STRING, 16384, null));
        this.register("last-modified", 1, e -> e.populate(FileLastModified::new, BuiltInAtomicType.DATE_TIME_STAMP, 16384, 512).arg(0, BuiltInAtomicType.STRING, 16384, null));
        this.register("line-separator", 0, e -> e.populate(FileLineSeparator::new, BuiltInAtomicType.STRING, 16384, 0));
        this.register("list", 1, e -> e.populate(FileList::new, BuiltInAtomicType.STRING, 57344, 512).arg(0, BuiltInAtomicType.STRING, 16384, null));
        this.register("list", 2, e -> e.populate(FileList::new, BuiltInAtomicType.STRING, 57344, 512).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, BuiltInAtomicType.BOOLEAN, 16384, null));
        this.register("list", 3, e -> e.populate(FileList::new, BuiltInAtomicType.STRING, 57344, 512).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, BuiltInAtomicType.BOOLEAN, 16384, null).arg(2, BuiltInAtomicType.STRING, 16384, null));
        this.register("move", 2, e -> e.populate(FileMove::new, AnyItemType.getInstance(), 57344, 8704).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, BuiltInAtomicType.STRING, 16384, null));
        this.register("name", 1, e -> e.populate(FileName::new, BuiltInAtomicType.STRING, 16384, 512).arg(0, BuiltInAtomicType.STRING, 16384, null));
        this.register("parent", 1, e -> e.populate(FileParent::new, BuiltInAtomicType.STRING, 24576, 512).arg(0, BuiltInAtomicType.STRING, 16384, null));
        this.register("path-separator", 0, e -> e.populate(FilePathSeparator::new, BuiltInAtomicType.STRING, 16384, 0));
        this.register("path-to-native", 1, e -> e.populate(FilePathToNative::new, BuiltInAtomicType.STRING, 16384, 512).arg(0, BuiltInAtomicType.STRING, 16384, null));
        this.register("path-to-uri", 1, e -> e.populate(FilePathToUri::new, BuiltInAtomicType.ANY_URI, 16384, 512).arg(0, BuiltInAtomicType.STRING, 16384, null));
        this.register("read-binary", 1, e -> e.populate(FileReadBinary::new, BuiltInAtomicType.BASE64_BINARY, 16384, 512).arg(0, BuiltInAtomicType.STRING, 16384, null));
        this.register("read-binary", 2, e -> e.populate(FileReadBinary::new, BuiltInAtomicType.BASE64_BINARY, 16384, 512).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, BuiltInAtomicType.INTEGER, 16384, null));
        this.register("read-binary", 3, e -> e.populate(FileReadBinary::new, BuiltInAtomicType.BASE64_BINARY, 16384, 512).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, BuiltInAtomicType.INTEGER, 16384, null).arg(2, BuiltInAtomicType.INTEGER, 16384, null));
        this.register("read-text", 1, e -> e.populate(FileReadText::new, BuiltInAtomicType.STRING, 16384, 512).arg(0, BuiltInAtomicType.STRING, 16384, null));
        this.register("read-text", 2, e -> e.populate(FileReadText::new, BuiltInAtomicType.STRING, 16384, 512).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, BuiltInAtomicType.STRING, 16384, null));
        this.register("read-text-lines", 1, e -> e.populate(FileReadTextLines::new, BuiltInAtomicType.STRING, 57344, 512).arg(0, BuiltInAtomicType.STRING, 16384, null));
        this.register("read-text-lines", 2, e -> e.populate(FileReadTextLines::new, BuiltInAtomicType.STRING, 57344, 512).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, BuiltInAtomicType.STRING, 16384, null));
        this.register("resolve-path", 1, e -> e.populate(FileResolvePath::new, BuiltInAtomicType.STRING, 16384, 512).arg(0, BuiltInAtomicType.STRING, 16384, null));
        this.register("size", 1, e -> e.populate(FileSize::new, BuiltInAtomicType.INTEGER, 16384, 512).arg(0, BuiltInAtomicType.STRING, 16384, null));
        this.register("temp-dir", 0, e -> e.populate(FileTempDir::new, BuiltInAtomicType.STRING, 16384, 512));
        this.register("write", 2, e -> e.populate(FileWrite::new, AnyItemType.getInstance(), 57344, 512).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, AnyItemType.getInstance(), 57344, null));
        this.register("write", 3, e -> e.populate(FileWrite::new, AnyItemType.getInstance(), 57344, 512).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, AnyItemType.getInstance(), 57344, null).arg(2, NodeKindTest.ELEMENT, 16384, null));
        this.register("write-binary", 2, e -> e.populate(FileWriteBinary::new, AnyItemType.getInstance(), 57344, 8704).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, BuiltInAtomicType.BASE64_BINARY, 16384, null));
        this.register("write-binary", 3, e -> e.populate(FileWriteBinary::new, AnyItemType.getInstance(), 57344, 8704).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, BuiltInAtomicType.BASE64_BINARY, 16384, null).arg(2, BuiltInAtomicType.INTEGER, 16384, null));
        this.register("write-text", 2, e -> e.populate(FileWriteText::new, AnyItemType.getInstance(), 57344, 8704).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, BuiltInAtomicType.STRING, 16384, null));
        this.register("write-text", 3, e -> e.populate(FileWriteText::new, AnyItemType.getInstance(), 57344, 8704).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, BuiltInAtomicType.STRING, 16384, null).arg(2, BuiltInAtomicType.STRING, 16384, null));
        this.register("write-text-lines", 2, e -> e.populate(FileWriteTextLines::new, AnyItemType.getInstance(), 57344, 8704).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, BuiltInAtomicType.STRING, 57344, null));
        this.register("write-text-lines", 3, e -> e.populate(FileWriteTextLines::new, AnyItemType.getInstance(), 57344, 8704).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, BuiltInAtomicType.STRING, 57344, null).arg(2, BuiltInAtomicType.STRING, 16384, null));
    }

    @Override
    public NamespaceUri getNamespace() {
        return NamespaceUri.EXPATH_FILE;
    }

    @Override
    public String getConventionalPrefix() {
        return "file";
    }

    private static FileOutputStream makeFileAppendOutputStream(File file) throws FileNotFoundException {
        return new FileOutputStream(file, true);
    }

    private static Writer newOutputStreamWriter(OutputStream stream, String encoding) throws XPathException {
        try {
            return new OutputStreamWriter(stream, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw EXPathFileFunctionSet.handleIOError(e);
        }
    }

    private static File toFile(String path) throws XPathException {
        try {
            File file = new File(path);
            if (file.isAbsolute()) {
                return file;
            }
            boolean maybeURI = path.startsWith("file:");
            if (maybeURI) {
                URI uri = new URI(path.replace("\\", "/"));
                return new File(uri.getPath());
            }
            String dir = System.getProperty("expath.base.directory");
            if (dir != null) {
                return new File(dir, path).getCanonicalFile();
            }
            return file.getCanonicalFile();
        }
        catch (URISyntaxException e) {
            throw new XPathException("URISyntax error in file path:" + path);
        }
        catch (IOException e) {
            throw new XPathException("IO error in file path:" + path);
        }
    }

    private static File toExistingFile(String path) throws XPathException {
        File file = EXPathFileFunctionSet.toFile(path);
        if (!file.exists()) {
            throw EXPathFileFunctionSet.error("No file exists at " + path, ERROR_PATH_NOT_EXIST);
        }
        return file;
    }

    private static File checkReadSource(String path) throws XPathException {
        File file = EXPathFileFunctionSet.toExistingFile(path);
        if (file.isDirectory()) {
            throw EXPathFileFunctionSet.error("Path " + path + " is a directory", ERROR_PATH_IS_DIRECTORY);
        }
        if (!file.exists()) {
            throw EXPathFileFunctionSet.error("File not found: " + path, ERROR_PATH_NOT_EXIST);
        }
        return file;
    }

    private static File checkWriteDestination(String path) throws XPathException {
        File file = EXPathFileFunctionSet.toFile(path);
        if (file.isDirectory()) {
            throw EXPathFileFunctionSet.error("Path " + path + " is a directory", ERROR_PATH_IS_DIRECTORY);
        }
        if (!file.getParentFile().exists()) {
            throw EXPathFileFunctionSet.error("Parent directory does not exist: " + path, ERROR_PATH_NOT_DIRECTORY);
        }
        return file;
    }

    private static File toExistingDirectory(String path) throws XPathException {
        File file = EXPathFileFunctionSet.toFile(path);
        if (!file.exists()) {
            throw EXPathFileFunctionSet.error("No directory exists at " + path, ERROR_PATH_NOT_DIRECTORY);
        }
        return file;
    }

    public static XPathException error(String message, String code) {
        XPathException e = new XPathException(message);
        e.setErrorCodeQName(new StructuredQName("file", ERROR_NAMESPACE, code));
        return e;
    }

    public static XPathException error(String message, Exception cause, String code) throws XPathException {
        XPathException e = new XPathException(message, cause);
        e.setErrorCodeQName(new StructuredQName("file", ERROR_NAMESPACE, code));
        return e;
    }

    private static void serialize(XPathContext context, String path, boolean append, Sequence contents, SerializationProperties properties) throws XPathException {
        Item item;
        FileOutputStream stream;
        SerializerFactory factory = context.getConfiguration().getSerializerFactory();
        PipelineConfiguration pipe = context.getController().makePipelineConfiguration();
        pipe.setXPathContext(context);
        File file = EXPathFileFunctionSet.toFile(path);
        if (file.isDirectory()) {
            throw EXPathFileFunctionSet.error("Path " + path + " is a directory", ERROR_PATH_IS_DIRECTORY);
        }
        try {
            stream = append ? EXPathFileFunctionSet.makeFileAppendOutputStream(file) : new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw EXPathFileFunctionSet.error("Failed to write to file " + path, e, ERROR_UNKNOWN_ENCODING);
        }
        StreamResult result = new StreamResult(stream);
        Receiver sr = factory.getReceiver((Result)result, properties, pipe);
        sr.open();
        sr.startDocument(0);
        SequenceIterator contentIter = contents.iterate();
        while ((item = contentIter.next()) != null) {
            sr.append(item);
        }
        sr.endDocument();
        sr.close();
        try {
            ((OutputStream)stream).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void copyDirectory(File from, File to) throws XPathException {
        for (File child : Objects.requireNonNull(from.listFiles())) {
            File target = new File(to, child.getName());
            if (child.isDirectory()) {
                if (target.exists()) {
                    if (!target.isDirectory()) {
                        boolean deleteOK = target.delete();
                        if (!deleteOK) {
                            throw EXPathFileFunctionSet.error("Failed to delete existing file " + target, ERROR_IO);
                        }
                        boolean mkOK = target.mkdir();
                        if (!mkOK) {
                            throw EXPathFileFunctionSet.error("Failed to create new directory " + target, ERROR_IO);
                        }
                    }
                } else {
                    boolean mkOK = target.mkdir();
                    if (!mkOK) {
                        throw EXPathFileFunctionSet.error("Failed to create new directory " + target, ERROR_IO);
                    }
                }
                EXPathFileFunctionSet.copyDirectory(child, target);
                continue;
            }
            if (target.exists() && target.isDirectory()) {
                throw EXPathFileFunctionSet.error("Cannot copy " + child.getAbsolutePath() + " because directory " + target.getAbsolutePath() + " is in the way", ERROR_PATH_IS_DIRECTORY);
            }
            EXPathFileFunctionSet.copyFile(child, target);
        }
    }

    private static void copyFile(File sourceFile, File destFile) throws XPathException {
        try {
            Query.createFileIfNecessary(destFile);
            Files.copy(sourceFile.toPath(), destFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        }
        catch (IOException e) {
            throw EXPathFileFunctionSet.handleIOError(e);
        }
    }

    private static void deleteTempFile(XPathContext context, File temp) {
        Boolean d = context.getConfiguration().getConfigurationProperty(Feature.EXPATH_FILE_DELETE_TEMPORARY_FILES);
        if (d.booleanValue()) {
            temp.deleteOnExit();
        }
    }

    private static void deleteRecursive(File file) throws IOException {
        if (file.isDirectory()) {
            for (File child : Objects.requireNonNull(file.listFiles())) {
                EXPathFileFunctionSet.deleteRecursive(child);
            }
        }
        file.delete();
    }

    private static XPathException handleIOError(IOException err) throws XPathException {
        XPathException xe = new XPathException(err);
        String localName = err instanceof UnsupportedEncodingException ? ERROR_UNKNOWN_ENCODING : ERROR_IO;
        xe.setErrorCodeQName(new StructuredQName("file", ERROR_NAMESPACE, localName));
        throw xe;
    }

    private static Reader getInputStreamReader(File file, String encoding) throws XPathException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            CharsetDecoder decoder = Charset.forName(encoding).newDecoder();
            decoder.onMalformedInput(CodingErrorAction.REPORT);
            return new InputStreamReader((InputStream)in, decoder);
        }
        catch (FileNotFoundException e) {
            throw EXPathFileFunctionSet.error("File not found: " + file.getAbsolutePath(), ERROR_PATH_NOT_EXIST);
        }
        catch (UnsupportedCharsetException e) {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e1) {
                    throw EXPathFileFunctionSet.error("Failed to close file " + file.getAbsolutePath(), e, ERROR_IO);
                }
            }
            throw EXPathFileFunctionSet.error("Unsupported encoding " + encoding, ERROR_UNKNOWN_ENCODING);
        }
        catch (IllegalCharsetNameException e) {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e1) {
                    throw EXPathFileFunctionSet.error("Failed to close file " + file.getAbsolutePath(), e, ERROR_IO);
                }
            }
            throw EXPathFileFunctionSet.error("Invalid encoding name " + encoding, ERROR_UNKNOWN_ENCODING);
        }
    }

    public static String _parent(String path) throws XPathException {
        if (path.equals("/")) {
            return null;
        }
        File file = EXPathFileFunctionSet.toFile(path);
        try {
            File parent = new File(file.getParent());
            return parent.getCanonicalPath() + File.separator;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static {
        ERROR_NAMESPACE = NAMESPACE = NamespaceUri.EXPATH_FILE;
        NEWLINE = System.getProperty("line.separator");
    }

    private static class TextFileLinesIterator
    extends TextLinesIterator {
        File file;
        String encoding;

        public TextFileLinesIterator(File file, String encoding, XPathContext context) throws XPathException {
            this.encoding = encoding;
            this.file = file;
            this.reader = new LineNumberReader(Objects.requireNonNull(EXPathFileFunctionSet.getInputStreamReader(file, encoding)));
            this.uri = file.toURI();
            this.checker = IntPredicateLambda.of(CSharp.methodRef(XMLCharacterData::isValid11));
            this.arrangeCleanup(this.reader, context);
        }
    }

    public static class FileWriteTextLines
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            String path = arguments[0].head().getStringValue();
            File file = EXPathFileFunctionSet.checkWriteDestination(path);
            SequenceIterator contents = arguments[1].iterate();
            String encoding = "UTF-8";
            if (arguments.length > 2) {
                encoding = arguments[2].head().getStringValue();
            }
            try {
                Item i;
                FileOutputStream stream = new FileOutputStream(file);
                Writer writer = EXPathFileFunctionSet.newOutputStreamWriter(stream, encoding);
                while ((i = contents.next()) != null) {
                    writer.write(i.getStringValue());
                    writer.write(NEWLINE);
                }
                writer.close();
            }
            catch (UnsupportedEncodingException e) {
                throw EXPathFileFunctionSet.error("Unsupported encoding " + encoding, EXPathFileFunctionSet.ERROR_UNKNOWN_ENCODING);
            }
            catch (FileNotFoundException e) {
                throw EXPathFileFunctionSet.error("Failed to create file", e, EXPathFileFunctionSet.ERROR_PATH_NOT_DIRECTORY);
            }
            catch (IOException e) {
                throw EXPathFileFunctionSet.error("Failed to write to file " + file.getAbsolutePath(), e, EXPathFileFunctionSet.ERROR_IO);
            }
            return EmptySequence.getInstance();
        }
    }

    public static class FileWriteText
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            String path = arguments[0].head().getStringValue();
            File file = EXPathFileFunctionSet.checkWriteDestination(path);
            String content = arguments[1].head().getStringValue();
            String encoding = "UTF-8";
            if (arguments.length > 2) {
                encoding = arguments[2].head().getStringValue();
            }
            try {
                FileOutputStream stream = new FileOutputStream(file);
                Writer writer = EXPathFileFunctionSet.newOutputStreamWriter(stream, encoding);
                writer.write(content);
                writer.close();
            }
            catch (UnsupportedEncodingException e) {
                throw EXPathFileFunctionSet.error("Unsupported encoding " + encoding, EXPathFileFunctionSet.ERROR_UNKNOWN_ENCODING);
            }
            catch (FileNotFoundException e) {
                throw EXPathFileFunctionSet.error("Failed to create file", e, EXPathFileFunctionSet.ERROR_PATH_NOT_DIRECTORY);
            }
            catch (IOException e) {
                throw EXPathFileFunctionSet.error("Failed to write to file " + file.getAbsolutePath(), e, EXPathFileFunctionSet.ERROR_IO);
            }
            return EmptySequence.getInstance();
        }
    }

    public static class FileWriteBinary
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            String path = arguments[0].head().getStringValue();
            File file = EXPathFileFunctionSet.checkWriteDestination(path);
            byte[] content = ((Base64BinaryValue)arguments[1].head()).getBinaryValue();
            if (arguments.length == 2) {
                try {
                    FileOutputStream stream = new FileOutputStream(file);
                    stream.write(content);
                    stream.close();
                }
                catch (IOException e) {
                    throw EXPathFileFunctionSet.error("Failed to write to file " + path, e, EXPathFileFunctionSet.ERROR_IO);
                }
            }
            try {
                byte[] data;
                long offset = ((NumericValue)arguments[2].head()).longValue();
                if (offset < 0L) {
                    throw EXPathFileFunctionSet.error("Negative offset in binary write:" + offset, EXPathFileFunctionSet.ERROR_INDEX_OUT_OF_BOUNDS);
                }
                int lb = content.length;
                if (file.exists() && offset > 0L) {
                    long fileLength = file.length();
                    if (offset > fileLength) {
                        throw EXPathFileFunctionSet.error("Offset exceeds file length in binary write:" + offset, EXPathFileFunctionSet.ERROR_INDEX_OUT_OF_BOUNDS);
                    }
                    FileInputStream in = new FileInputStream(file);
                    data = new byte[Math.max((int)fileLength, (int)offset + lb)];
                    int bytes = in.read(data);
                    if ((long)bytes != fileLength) {
                        in.close();
                        throw EXPathFileFunctionSet.error("Number of bytes read does not match file length", EXPathFileFunctionSet.ERROR_IO);
                    }
                    in.close();
                } else {
                    data = new byte[(int)offset + lb];
                }
                System.arraycopy(content, 0, data, (int)offset, lb);
                FileOutputStream stream = new FileOutputStream(file);
                stream.write(data);
                stream.close();
            }
            catch (IOException e) {
                throw EXPathFileFunctionSet.error("Failed to write to file " + path, e, EXPathFileFunctionSet.ERROR_IO);
            }
            return EmptySequence.getInstance();
        }
    }

    public static class FileWrite
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            SerializationProperties params;
            String path = arguments[0].head().getStringValue();
            Sequence contents = arguments[1];
            if (arguments.length > 2) {
                SerializationParamsHandler sph = new SerializationParamsHandler();
                sph.setSerializationParams((NodeInfo)arguments[2].head());
                params = sph.getSerializationProperties();
            } else {
                params = context.getConfiguration().obtainDefaultSerializationProperties();
            }
            EXPathFileFunctionSet.serialize(context, path, false, contents, params);
            return EmptySequence.getInstance();
        }
    }

    public static class FileTempDir
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            String fs = System.getProperty("file.separator");
            String tmp = System.getProperty("java.io.tmpdir");
            if (!tmp.endsWith(fs)) {
                tmp = tmp + fs;
            }
            return new StringValue(tmp);
        }
    }

    public static class FileSize
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            File file = EXPathFileFunctionSet.toExistingFile(arguments[0].head().getStringValue());
            return new Int64Value(file.isDirectory() ? 0L : file.length());
        }
    }

    public static class FileResolvePath
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            File file = EXPathFileFunctionSet.toFile(arguments[0].head().getStringValue());
            return new StringValue(file.getAbsolutePath() + (file.isDirectory() ? File.separator : ""));
        }
    }

    public static class FileReadTextLines
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            String path = arguments[0].head().getStringValue();
            File file = EXPathFileFunctionSet.checkReadSource(path);
            String encoding = "UTF-8";
            if (arguments.length > 1) {
                encoding = arguments[1].head().getStringValue();
            }
            return new LazySequence(new TextFileLinesIterator(file, encoding, context));
        }
    }

    public static class FileReadText
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            String path = arguments[0].head().getStringValue();
            File file = EXPathFileFunctionSet.checkReadSource(path);
            String encoding = "UTF-8";
            if (arguments.length > 1) {
                encoding = arguments[1].head().getStringValue();
            }
            Reader reader = Objects.requireNonNull(EXPathFileFunctionSet.getInputStreamReader(file, encoding));
            try {
                String result = UnparsedTextFunction.readFile(context.getConfiguration().getValidCharacterChecker(), reader).toString();
                reader.close();
                return new StringValue(result);
            }
            catch (XPathException e) {
                try {
                    reader.close();
                }
                catch (IOException e1) {
                    throw EXPathFileFunctionSet.error("Failed to close file " + file.getAbsolutePath(), e, EXPathFileFunctionSet.ERROR_IO);
                }
                throw EXPathFileFunctionSet.error(e.getMessage(), EXPathFileFunctionSet.ERROR_IO);
            }
            catch (IOException e) {
                try {
                    reader.close();
                }
                catch (IOException e1) {
                    throw EXPathFileFunctionSet.error("Failed to close file " + file.getAbsolutePath(), e, EXPathFileFunctionSet.ERROR_IO);
                }
                throw EXPathFileFunctionSet.error("Failed to read file " + path, e, EXPathFileFunctionSet.ERROR_IO);
            }
        }
    }

    public static class FileReadBinary
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            String path = arguments[0].head().getStringValue();
            File file = EXPathFileFunctionSet.checkReadSource(path);
            long offset = 0L;
            if (arguments.length > 1) {
                offset = ((NumericValue)arguments[1].head()).longValue();
            }
            long length = file.length() - offset;
            if (arguments.length > 2) {
                length = ((NumericValue)arguments[2].head()).longValue();
            }
            return FileReadBinary.readBinary(file, path, offset, length);
        }

        private static Base64BinaryValue readBinary(File file, String path, long offset, long length) throws XPathException {
            try {
                long skipped;
                long fileLength = file.length();
                if (offset < 0L) {
                    throw EXPathFileFunctionSet.error("Negative offset in binary read:" + offset, EXPathFileFunctionSet.ERROR_INDEX_OUT_OF_BOUNDS);
                }
                if (length < 0L) {
                    throw EXPathFileFunctionSet.error("Negative length in binary read:" + length, EXPathFileFunctionSet.ERROR_INDEX_OUT_OF_BOUNDS);
                }
                if (offset + length > fileLength) {
                    throw EXPathFileFunctionSet.error("Length exceeds file length in binary read:" + (offset + length), EXPathFileFunctionSet.ERROR_INDEX_OUT_OF_BOUNDS);
                }
                byte[] content = new byte[(int)length];
                FileInputStream in = new FileInputStream(file);
                if (offset > 0L && (skipped = in.skip(offset)) != offset) {
                    throw EXPathFileFunctionSet.error("Error skipping content at start of binary: " + skipped + " bytes skipped, but requested " + offset, EXPathFileFunctionSet.ERROR_IO);
                }
                int bytes = in.read(content, 0, (int)length);
                if (bytes != content.length) {
                    in.close();
                    throw EXPathFileFunctionSet.error("Number of bytes read does not match file length", EXPathFileFunctionSet.ERROR_IO);
                }
                in.close();
                return new Base64BinaryValue(content);
            }
            catch (IOException e) {
                throw EXPathFileFunctionSet.error("Failed to read file " + path, e, EXPathFileFunctionSet.ERROR_IO);
            }
        }
    }

    public static class FilePathToUri
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            String filePath = arguments[0].head().getStringValue();
            URI uri = File.separator.equals("\\") && (filePath.startsWith("\\\\") || filePath.startsWith("//")) ? new File(filePath).toPath().toUri() : EXPathFileFunctionSet.toFile(filePath).toURI().normalize();
            return new AnyURIValue(FilePathToUri.escapeCS(uri.toString()));
        }

        private static String escapeCS(String s) {
            return s;
        }
    }

    public static class FilePathToNative
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            String path = arguments[0].head().getStringValue();
            File file = null;
            if (path.startsWith("file:/")) {
                try {
                    URI uri = new URI(path);
                    file = new File(uri);
                    if (!file.exists()) {
                        throw EXPathFileFunctionSet.error("No file exists at " + path, EXPathFileFunctionSet.ERROR_PATH_NOT_EXIST);
                    }
                }
                catch (URISyntaxException uri) {
                    // empty catch block
                }
            }
            if (file == null) {
                file = EXPathFileFunctionSet.toExistingFile(path);
            }
            try {
                return new StringValue(file.getCanonicalPath());
            }
            catch (IOException e) {
                throw EXPathFileFunctionSet.handleIOError(e);
            }
        }
    }

    public static class FilePathSeparator
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            return new StringValue(File.pathSeparator);
        }
    }

    public static class FileParent
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            String path = arguments[0].head().getStringValue();
            if (path.equals("/")) {
                return EmptySequence.getInstance();
            }
            File file = EXPathFileFunctionSet.toFile(path);
            try {
                File parent = new File(file.getParent());
                return new StringValue(parent.getCanonicalPath() + File.separator);
            }
            catch (IOException e) {
                throw EXPathFileFunctionSet.handleIOError(e);
            }
        }
    }

    public static class FileName
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            String path = arguments[0].head().getStringValue();
            if (path.equals("/") || path.equals("")) {
                return StringValue.EMPTY_STRING;
            }
            File file = EXPathFileFunctionSet.toFile(path);
            return new StringValue(file.getName());
        }
    }

    public static class FileMove
    extends SystemFunction {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            File from = EXPathFileFunctionSet.toExistingFile(arguments[0].head().getStringValue());
            File to = EXPathFileFunctionSet.toFile(arguments[1].head().getStringValue());
            if (from.isDirectory()) {
                if (to.exists()) {
                    if (!to.isDirectory()) throw EXPathFileFunctionSet.error("Target of directory move exists and is not a directory", EXPathFileFunctionSet.ERROR_PATH_EXISTS);
                    boolean success = from.renameTo(new File(to, from.getName()));
                    if (success) return EmptySequence.getInstance();
                    throw EXPathFileFunctionSet.error("Renaming of " + from.getName() + " failed", EXPathFileFunctionSet.ERROR_IO);
                }
                boolean created = to.mkdirs();
                if (!created) {
                    throw EXPathFileFunctionSet.error("Creation of " + to + " failed", EXPathFileFunctionSet.ERROR_IO);
                }
                for (File f : Objects.requireNonNull(from.listFiles())) {
                    boolean success = f.renameTo(new File(to, f.getName()));
                    if (success) continue;
                    throw EXPathFileFunctionSet.error("Renaming of " + f + " failed", EXPathFileFunctionSet.ERROR_IO);
                }
                return EmptySequence.getInstance();
            } else {
                boolean success;
                if (to.isDirectory()) {
                    to = new File(to, from.getName());
                }
                if (to.exists() && !(success = to.delete())) {
                    throw EXPathFileFunctionSet.error("Deletion of existing file " + to + " failed", EXPathFileFunctionSet.ERROR_IO);
                }
                boolean result = from.renameTo(to);
                if (result) return EmptySequence.getInstance();
                throw EXPathFileFunctionSet.error("Moving " + from + " to " + to + " failed ", EXPathFileFunctionSet.ERROR_IO);
            }
        }
    }

    public static class FileList
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            String path = arguments[0].head().getStringValue();
            File file = EXPathFileFunctionSet.toExistingDirectory(path);
            if (!file.isDirectory()) {
                throw EXPathFileFunctionSet.error("File " + path + " is not a directory", EXPathFileFunctionSet.ERROR_PATH_NOT_DIRECTORY);
            }
            boolean recursive = false;
            if (arguments.length > 1) {
                recursive = ((BooleanValue)arguments[1].head()).getBooleanValue();
            }
            ArrayList<StringValue> result = new ArrayList<StringValue>();
            FilenameFilter filter = arguments.length > 2 ? URIQueryParameters.makeGlobFilter(arguments[2].head().getStringValue()) : null;
            FileList.gatherDirectoryContents(file, "", recursive, filter, result);
            return SequenceExtent.makeSequenceExtent(result);
        }

        private static void gatherDirectoryContents(File dir, String prefix, boolean recurse, FilenameFilter filter, List<StringValue> result) {
            String name;
            URIQueryParameters.RegexFilter filter2 = filter instanceof URIQueryParameters.RegexFilter ? (URIQueryParameters.RegexFilter)filter : null;
            for (File file : Objects.requireNonNull(dir.listFiles(filter))) {
                if (filter2 != null && file.isDirectory() && !filter2.matches(file.getName())) continue;
                String string = name = prefix.isEmpty() ? file.getName() : prefix + File.separator + file.getName();
                if (file.isDirectory()) {
                    name = name + File.separator;
                }
                result.add(new StringValue(name));
            }
            if (recurse) {
                for (File file : Objects.requireNonNull(dir.listFiles())) {
                    if (!file.isDirectory()) continue;
                    name = prefix.isEmpty() ? file.getName() : prefix + File.separator + file.getName();
                    FileList.gatherDirectoryContents(file, name, true, filter, result);
                }
            }
        }
    }

    public static class FileLineSeparator
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            return new StringValue(NEWLINE);
        }
    }

    public static class FileLastModified
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            File file = EXPathFileFunctionSet.toExistingFile(arguments[0].head().getStringValue());
            long dt = file.lastModified();
            return DateTimeValue.EPOCH.add(DayTimeDurationValue.fromMilliseconds(dt));
        }
    }

    public static class FileIsFile
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            File file = EXPathFileFunctionSet.toFile(arguments[0].head().getStringValue());
            return BooleanValue.get(file.exists() && file.isFile());
        }
    }

    public static class FileIsDir
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            File file = EXPathFileFunctionSet.toFile(arguments[0].head().getStringValue());
            return BooleanValue.get(file.exists() && file.isDirectory());
        }
    }

    public static class FileExists
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            File file = EXPathFileFunctionSet.toFile(arguments[0].head().getStringValue());
            return BooleanValue.get(file.exists());
        }
    }

    public static class FileDirSeparator
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            return new StringValue(File.separator);
        }
    }

    public static class FileDelete
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            String path = arguments[0].head().getStringValue();
            File file = EXPathFileFunctionSet.toExistingFile(path);
            boolean recurse = false;
            if (arguments.length == 2) {
                recurse = ((BooleanValue)arguments[1].head()).getBooleanValue();
            }
            if (!recurse) {
                if (file.isDirectory() && file.list().length != 0) {
                    throw EXPathFileFunctionSet.error("Cannot delete non-empty directory " + file.getAbsolutePath(), EXPathFileFunctionSet.ERROR_PATH_IS_DIRECTORY);
                }
                boolean result = file.delete();
                if (!result) {
                    throw EXPathFileFunctionSet.error("Failed to delete file " + file.getAbsolutePath(), EXPathFileFunctionSet.ERROR_IO);
                }
            } else {
                try {
                    EXPathFileFunctionSet.deleteRecursive(file);
                }
                catch (IOException e) {
                    throw EXPathFileFunctionSet.error("Failed to delete " + path, e, EXPathFileFunctionSet.ERROR_IO);
                }
            }
            return EmptySequence.getInstance();
        }
    }

    public static class FileCurrentDir
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            File file = EXPathFileFunctionSet.toFile(".");
            return new StringValue(file.getAbsolutePath() + (file.isDirectory() ? File.separator : ""));
        }
    }

    public static class FileCreateTempFile
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            try {
                File temp;
                String prefix = arguments[0].head().getStringValue();
                String suffix = arguments[1].head().getStringValue();
                if (arguments.length == 2) {
                    temp = File.createTempFile(prefix, suffix);
                } else {
                    String dir = arguments[2].head().getStringValue();
                    temp = File.createTempFile(prefix, suffix, EXPathFileFunctionSet.toFile(dir));
                }
                EXPathFileFunctionSet.deleteTempFile(context, temp);
                return new StringValue(temp.getCanonicalPath());
            }
            catch (IOException e) {
                throw EXPathFileFunctionSet.handleIOError(e);
            }
        }
    }

    public static class FileCreateTempDir
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            try {
                File test;
                String prefix = arguments[0].head().getStringValue();
                String suffix = arguments[1].head().getStringValue();
                if (arguments.length == 2) {
                    test = File.createTempFile(prefix, suffix);
                } else {
                    String dir = arguments[2].head().getStringValue();
                    test = File.createTempFile(prefix, suffix, EXPathFileFunctionSet.toFile(dir));
                }
                String path = test.getCanonicalPath();
                test.delete();
                File temp = new File(path);
                temp.mkdirs();
                EXPathFileFunctionSet.deleteTempFile(context, temp);
                return new StringValue(temp.getCanonicalPath());
            }
            catch (IOException e) {
                throw EXPathFileFunctionSet.handleIOError(e);
            }
        }
    }

    public static class FileCreateDir
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            String path = arguments[0].head().getStringValue();
            File file = EXPathFileFunctionSet.toFile(path);
            if (file.exists()) {
                if (!file.isDirectory()) {
                    throw EXPathFileFunctionSet.error("Path " + path + " already exists and is not a directory", EXPathFileFunctionSet.ERROR_PATH_EXISTS);
                }
            } else {
                boolean result = file.mkdirs();
                if (!result) {
                    throw EXPathFileFunctionSet.error("Failed to create directory " + path, EXPathFileFunctionSet.ERROR_PATH_EXISTS);
                }
            }
            return EmptySequence.getInstance();
        }
    }

    public static class FileCopy
    extends SystemFunction {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            File from = EXPathFileFunctionSet.toFile(arguments[0].head().getStringValue());
            File to = EXPathFileFunctionSet.toFile(arguments[1].head().getStringValue());
            if (from.exists() && from.isDirectory()) {
                if (to.exists()) {
                    if (!to.isDirectory()) throw EXPathFileFunctionSet.error("Source is a directory but target is a file", EXPathFileFunctionSet.ERROR_PATH_EXISTS);
                    to = new File(to, from.getName());
                    to.mkdir();
                    EXPathFileFunctionSet.copyDirectory(from, to);
                    return EmptySequence.getInstance();
                } else {
                    to.mkdir();
                    EXPathFileFunctionSet.copyDirectory(from, to);
                }
                return EmptySequence.getInstance();
            } else {
                if (to.exists() && to.isDirectory()) {
                    to = new File(to, from.getName());
                }
                EXPathFileFunctionSet.copyFile(from, to);
            }
            return EmptySequence.getInstance();
        }
    }

    public static class FileChildren
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            ArrayList<StringValue> result = new ArrayList<StringValue>();
            String dir = arguments[0].head().getStringValue();
            File fd = EXPathFileFunctionSet.toExistingDirectory(dir);
            if (!fd.isDirectory()) {
                throw EXPathFileFunctionSet.error("File " + dir + " is not a directory", EXPathFileFunctionSet.ERROR_PATH_NOT_DIRECTORY);
            }
            for (File file : Objects.requireNonNull(fd.listFiles())) {
                result.add(new StringValue(file.getAbsolutePath() + (file.isDirectory() ? File.separator : "")));
            }
            return SequenceExtent.makeSequenceExtent(result);
        }
    }

    public static class FileAppendTextLines
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            String path = arguments[0].head().getStringValue();
            String encoding = "UTF-8";
            if (arguments.length > 2) {
                encoding = arguments[2].head().getStringValue();
            }
            try {
                Item item;
                File file = EXPathFileFunctionSet.toFile(path);
                if (file.isDirectory()) {
                    throw EXPathFileFunctionSet.error("Path " + path + " is a directory", EXPathFileFunctionSet.ERROR_PATH_IS_DIRECTORY);
                }
                Writer writer = EXPathFileFunctionSet.newOutputStreamWriter(EXPathFileFunctionSet.makeFileAppendOutputStream(file), encoding);
                SequenceIterator iter = arguments[1].iterate();
                while ((item = iter.next()) != null) {
                    writer.write(item.getStringValue());
                    writer.write(NEWLINE);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw EXPathFileFunctionSet.error("Unsupported encoding " + encoding, EXPathFileFunctionSet.ERROR_UNKNOWN_ENCODING);
            }
            catch (FileNotFoundException e) {
                throw EXPathFileFunctionSet.error("Failed to create file", e, EXPathFileFunctionSet.ERROR_PATH_NOT_DIRECTORY);
            }
            catch (IOException e) {
                throw EXPathFileFunctionSet.error("Failed to write to file " + path, e, EXPathFileFunctionSet.ERROR_IO);
            }
            return EmptySequence.getInstance();
        }
    }

    public static class FileAppendText
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            String path = arguments[0].head().getStringValue();
            String contents = arguments[1].head().getStringValue();
            String encoding = "UTF-8";
            if (arguments.length > 2) {
                encoding = arguments[2].head().getStringValue();
            }
            File file = null;
            try {
                file = EXPathFileFunctionSet.toFile(path);
                if (file.isDirectory()) {
                    throw EXPathFileFunctionSet.error("Path " + path + " is a directory", EXPathFileFunctionSet.ERROR_PATH_IS_DIRECTORY);
                }
                Writer writer = Objects.requireNonNull(EXPathFileFunctionSet.newOutputStreamWriter(EXPathFileFunctionSet.makeFileAppendOutputStream(file), encoding));
                writer.write(contents);
                writer.close();
            }
            catch (UnsupportedEncodingException e) {
                throw EXPathFileFunctionSet.error("Unsupported encoding " + encoding, EXPathFileFunctionSet.ERROR_UNKNOWN_ENCODING);
            }
            catch (FileNotFoundException e) {
                throw EXPathFileFunctionSet.error("Failed to create file", e, EXPathFileFunctionSet.ERROR_PATH_NOT_DIRECTORY);
            }
            catch (IOException e) {
                throw EXPathFileFunctionSet.error("Failed to write to file " + file.getAbsolutePath(), e, EXPathFileFunctionSet.ERROR_IO);
            }
            return EmptySequence.getInstance();
        }
    }

    public static class FileAppendBinary
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            String path = arguments[0].head().getStringValue();
            try {
                File file = EXPathFileFunctionSet.toFile(path);
                if (file.isDirectory()) {
                    throw EXPathFileFunctionSet.error("Path " + path + " is a directory", EXPathFileFunctionSet.ERROR_PATH_IS_DIRECTORY);
                }
                FileOutputStream stream = EXPathFileFunctionSet.makeFileAppendOutputStream(file);
                Base64BinaryValue contents = (Base64BinaryValue)arguments[1].head();
                stream.write(contents.getBinaryValue());
                stream.close();
            }
            catch (FileNotFoundException e) {
                throw EXPathFileFunctionSet.error("Failed to create file", e, EXPathFileFunctionSet.ERROR_PATH_NOT_DIRECTORY);
            }
            catch (IOException e) {
                throw EXPathFileFunctionSet.error("Failed to write to file " + path, e, EXPathFileFunctionSet.ERROR_IO);
            }
            return EmptySequence.getInstance();
        }
    }

    public static class FileAppend
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            SerializationProperties params;
            String path = arguments[0].head().getStringValue();
            if (arguments.length > 2) {
                SerializationParamsHandler sph = new SerializationParamsHandler();
                sph.setSerializationParams((NodeInfo)arguments[2].head());
                params = sph.getSerializationProperties();
            } else {
                Properties props = new Properties();
                props.setProperty("method", "xml");
                params = new SerializationProperties(props);
            }
            EXPathFileFunctionSet.serialize(context, path, true, arguments[1], params);
            return EmptySequence.getInstance();
        }
    }

    public static class FileBaseDir
    extends SystemFunction {
        @Override
        public Expression makeFunctionCall(Expression ... arguments) {
            if (this.getRetainedStaticContext().getPackageData().isRelocatable()) {
                return super.makeFunctionCall(arguments);
            }
            try {
                return Literal.makeLiteral(FileBaseDir.makeResult(this.getStaticBaseUriString()));
            }
            catch (XPathException e) {
                return new ErrorExpression(new XmlProcessingException(e));
            }
        }

        @Override
        public Sequence call(XPathContext context, Sequence[] args) throws XPathException {
            return FileBaseDir.makeResult(this.getStaticBaseUriString());
        }

        private static GroundedValue makeResult(String baseURI) throws XPathException {
            if (baseURI == null) {
                return EmptySequence.getInstance();
            }
            String parent = EXPathFileFunctionSet._parent(baseURI);
            if (parent == null) {
                return EmptySequence.getInstance();
            }
            return StringValue.makeStringValue(parent);
        }
    }
}

